/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class IterationSafeEvictingQueue<E>
implements Queue<E> {
    public static final int MAX_CAPACITY = 0x40000000;
    protected Object[] queue;
    protected final int maxCapacity;
    protected final int maxCapacityPowerOfTwo;
    protected final Consumer<E> onEvict;
    protected int head;
    protected int size;

    public IterationSafeEvictingQueue(int initialCapacity, int maxCapacity) {
        this(initialCapacity, maxCapacity, e -> {});
    }

    public IterationSafeEvictingQueue(int initialCapacity, int maxCapacity, Consumer<E> onEvict) {
        if (initialCapacity < 0 || maxCapacity <= 0 || initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("Invalid capacities, initialCapacity: " + initialCapacity + ", maxCapacity: " + maxCapacity);
        }
        this.queue = new Object[IterationSafeEvictingQueue.roundUpToPowerOfTwo(Math.max(8, initialCapacity))];
        this.maxCapacity = maxCapacity;
        this.maxCapacityPowerOfTwo = IterationSafeEvictingQueue.roundUpToPowerOfTwo(maxCapacity);
        this.onEvict = onEvict;
        this.head = 0;
        this.size = 0;
    }

    public static <E> IterationSafeEvictingQueue<E> newInstance(int initialCapacity, int maxCapacity) {
        return new IterationSafeEvictingQueue<E>(Math.min(initialCapacity, maxCapacity), maxCapacity);
    }

    public static <E> IterationSafeEvictingQueue<E> newInstance(int initialCapacity, int maxCapacity, Consumer<E> onEvict) {
        return new IterationSafeEvictingQueue<E>(Math.min(initialCapacity, maxCapacity), maxCapacity, onEvict);
    }

    @Override
    public boolean offer(E item) {
        if (item == null) {
            throw new NullPointerException("Item cannot be null");
        }
        Object[] q = this.queue;
        int capacity = q.length;
        int size = this.size;
        if (size >= this.maxCapacity) {
            int head = this.head;
            this.head = head + 1 & capacity - 1;
            Object evicted = q[head];
            if (evicted != null) {
                this.onEvict.accept(evicted);
            }
            q[head] = null;
            q[head + size & capacity - 1] = item;
        } else {
            if (capacity == size) {
                q = this.resize(capacity <<= 1);
            }
            q[this.head + size & capacity - 1] = item;
            ++this.size;
        }
        return true;
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        Object[] q = this.queue;
        int head = this.head;
        Object item = q[head];
        this.head = head + 1 & q.length - 1;
        q[head] = null;
        --this.size;
        return (E)item;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        while (true) {
            Object[] queue;
            int head;
            if ((head = this.head) >= (queue = this.queue).length) {
                Thread.yield();
                continue;
            }
            Object o = queue[head];
            if (o != null) {
                return (E)o;
            }
            if (this.size == 0) break;
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private Object[] resize(int newCapacity) {
        if (newCapacity > this.maxCapacityPowerOfTwo) {
            throw new IllegalStateException("Cannot increase capacity beyond max capacity " + this.maxCapacityPowerOfTwo + " : " + newCapacity);
        }
        Object[] q = this.queue;
        int head = this.head;
        int tail = head + this.size;
        int capacity = q.length;
        Object[] a = new Object[newCapacity];
        if (tail <= capacity) {
            System.arraycopy(q, head, a, head, this.size);
        } else {
            int l = capacity - head;
            System.arraycopy(q, head, a, 0, l);
            System.arraycopy(q, 0, a, l, tail - capacity);
        }
        this.queue = a;
        this.head = 0;
        return a;
    }

    public int arraySize() {
        return this.queue.length;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new QueueIterator();
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public E remove() {
        E item = this.poll();
        if (item == null) {
            throw new NoSuchElementException("Queue is empty");
        }
        return item;
    }

    @Override
    public E element() {
        E item = this.peek();
        if (item == null) {
            throw new NoSuchElementException("Queue is empty");
        }
        return item;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        if (c.isEmpty()) {
            return false;
        }
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.removeIf(c::contains);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.removeIf(e -> !c.contains(e));
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter) {
        int i;
        Object[] a = this.queue;
        int mask = a.length - 1;
        int to = this.size + i;
        for (i = this.head; i < to && !filter.test(a[i & mask]); ++i) {
        }
        if (i == to) {
            return false;
        }
        Object[] b = new Object[a.length];
        if (i > a.length) {
            System.arraycopy(a, this.head, b, this.head, a.length - this.head);
            System.arraycopy(a, 0, b, 0, i - a.length);
        } else {
            System.arraycopy(a, this.head, b, this.head, i - this.head);
        }
        int j = i++;
        while (i < to) {
            Object e = a[i & mask];
            if (!filter.test(e)) {
                b[j++ & mask] = e;
            }
            ++i;
        }
        this.queue = b;
        this.size = j - this.head;
        return true;
    }

    private void removeIndex(Object[] q, int toRemove, int tail) {
        int l = tail - toRemove;
        int mask = q.length - 1;
        if (l > 0) {
            if (tail <= q.length) {
                System.arraycopy(q, toRemove + 1, q, toRemove, l - 1);
            } else if (toRemove <= mask) {
                if (toRemove < mask) {
                    System.arraycopy(q, toRemove + 1, q, toRemove, q.length - toRemove - 1);
                }
                q[mask] = q[0];
                System.arraycopy(q, 1, q, 0, tail - q.length - 1);
            } else {
                System.arraycopy(q, toRemove + 1 & mask, q, toRemove & mask, l - 1);
            }
        }
        q[tail - 1 & mask] = null;
        --this.size;
    }

    @Override
    public void clear() {
        int head = this.head;
        int tail = head + this.size;
        Object[] q = this.queue;
        int capacity = q.length;
        if (tail <= capacity) {
            Arrays.fill(q, head, tail, null);
        } else {
            Arrays.fill(q, head, capacity, null);
            Arrays.fill(q, 0, tail - capacity, null);
        }
        this.head = 0;
        this.size = 0;
    }

    @Override
    public boolean contains(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        Object[] q = this.queue;
        int mask = q.length - 1;
        int to = i + this.size;
        for (i = this.head; i < to; ++i) {
            if (!o.equals(q[i & mask])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object @NotNull [] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public <T> T @NotNull [] toArray(T[] a) {
        Object[] q;
        int capacity;
        int head;
        int tail;
        int size = this.size;
        if (size > a.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        if ((tail = (head = this.head) + size) <= (capacity = (q = this.queue).length)) {
            System.arraycopy(q, head, a, 0, size);
        } else {
            int l = capacity - head;
            System.arraycopy(q, head, a, 0, l);
            System.arraycopy(q, 0, a, l, tail - capacity);
        }
        if (size < a.length) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean remove(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        Object[] q = this.queue;
        int capacity = q.length;
        int to = this.size + i;
        for (i = this.head; i < to; ++i) {
            int index = i & capacity - 1;
            if (!o.equals(q[index])) continue;
            this.removeIndex(q, i, to);
            return true;
        }
        return false;
    }

    private static int roundUpToPowerOfTwo(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive: " + n);
        }
        if (n > 0x40000000) {
            throw new IllegalArgumentException("n cannot larger than 1073741824 : " + n);
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            sb.append(it.next());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    private class QueueIterator
    implements Iterator<E> {
        private final Object[] a;
        private final int mask;
        private final int head;
        private int tail;
        private int cursor;
        private Object curr;
        private Object next;

        private QueueIterator() {
            this.a = IterationSafeEvictingQueue.this.queue;
            this.mask = this.a.length - 1;
            this.head = IterationSafeEvictingQueue.this.head;
            this.tail = IterationSafeEvictingQueue.this.size + this.head;
            this.cursor = this.head;
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            Object e = this.curr;
            while (this.cursor < this.tail) {
                this.next = this.a[this.cursor++ & this.mask];
                if (this.next == null || this.next == e) continue;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object next = this.next;
            this.next = null;
            this.curr = next;
            return this.curr;
        }

        @Override
        public void remove() {
            int i;
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            for (i = this.cursor - 1; i >= this.head && this.a[i & this.mask] != this.curr; --i) {
            }
            if (i < 0) {
                throw new IllegalStateException();
            }
            IterationSafeEvictingQueue.this.removeIndex(this.a, i, this.tail);
            --this.tail;
            this.curr = null;
        }
    }
}

