/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncParticlesClient;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncRenderer;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.LightCachedParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.addon.ParticleAddon;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.api.EndTickEvent;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.api.EndTickOperation;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.a_good_place.AGoodPlaceCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.particlerain.ParticleRainCompat;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.config.ConfigHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.BusyWaitEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionTracker;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ExceptionUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.IterationSafeEvictingQueue;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.Utils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TrackingEmitter;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AsyncTicker {
    public static final Logger LOGGER = LogManager.getLogger();
    private static final Set<Class<? extends Particle>> SYNC_PARTICLE_TYPES = Collections.newSetFromMap(new IdentityHashMap());
    private static final Set<Particle> SYNC_PARTICLES = Collections.newSetFromMap(new IdentityHashMap());
    public static final List<Runnable> PARTICLE_OPERATIONS = new ArrayList<Runnable>();
    private static boolean cancelled = false;
    public static boolean shouldTickParticles = false;
    public static CompletableFuture<Void> particleCleanup;
    private static final List<EndTickEvent> SEQUENCED_END_TICK_EVENTS;
    private static final List<EndTickEvent> PARALLEL_END_TICK_EVENTS;
    private static final List<EndTickOperation> END_TICK_OPERATIONS;
    private static CompletableFuture<Void> particleFuture;
    private static boolean debug_cancelled;
    private static Consumer<String> debugConsumer;
    private static boolean shouldReload;
    public static final ForkJoinPool EXECUTOR;
    public static final String THREAD_PREFIX = "AsyncParticleTicker";
    private static final ExceptionTracker<Object> EXCEPTION_TRACKER;
    private static final AtomicLong timeUsageNano;

    private static void addSyncByClassName(String className) {
        try {
            SYNC_PARTICLE_TYPES.add(Class.forName(className));
        }
        catch (Exception e) {
            LOGGER.warn("", (Throwable)e);
        }
    }

    public static boolean isCancelled() {
        if (!cancelled) {
            return false;
        }
        debug_cancelled = true;
        return true;
    }

    public static void onTickBefore(int i, int to, ProfilerFiller profiler) {
        boolean levelRunning;
        if (!ConfigHelper.isTickAsync()) {
            return;
        }
        profiler.push("async_particles");
        Minecraft mc = Minecraft.getInstance();
        boolean bl = levelRunning = mc.level != null && mc.player != null && !mc.isPaused();
        if (i != 0) {
            shouldTickParticles = i == to - 1 && levelRunning;
        } else {
            cancelled = true;
            debug_cancelled = false;
            if (particleFuture != null) {
                particleFuture.join();
                particleFuture = null;
            }
            cancelled = false;
            boolean bl2 = shouldTickParticles = i == to - 1 && levelRunning;
            if (levelRunning) {
                ParticleEngine particleEngine = mc.particleEngine;
                Collection values = particleEngine.particles.values();
                CompletableFuture[] futures = new CompletableFuture[values.size() + 1];
                Queue trackingEmitters = particleEngine.trackingEmitters;
                futures[0] = trackingEmitters.isEmpty() ? Utils.NULL_FUTURE : CompletableFuture.runAsync(() -> trackingEmitters.removeIf(trackingEmitter -> !trackingEmitter.isAlive()), EXECUTOR);
                int k = 1;
                boolean removeIfMissedTick = ConfigHelper.isRemoveIfMissedTick();
                for (Queue particles : values) {
                    if (particles.isEmpty()) {
                        futures[k++] = Utils.NULL_FUTURE;
                        continue;
                    }
                    futures[k++] = CompletableFuture.runAsync(() -> particles.removeIf(particle1 -> {
                        if (!particle1.isAlive()) {
                            particle1.getParticleGroup().ifPresent(group -> particleEngine.updateCount(group, -1));
                            return true;
                        }
                        ParticleAddon particleAddon = (ParticleAddon)particle1;
                        if (particleAddon.asyncparticles$isTickSync()) {
                            return false;
                        }
                        if (particleAddon.asyncparticles$isTicked()) {
                            particleAddon.asyncparticles$resetTicked();
                            return false;
                        }
                        if (removeIfMissedTick) {
                            particle1.remove();
                            particle1.getParticleGroup().ifPresent(group -> particleEngine.updateCount(group, -1));
                            return true;
                        }
                        return false;
                    }), EXECUTOR);
                }
                particleCleanup = CompletableFuture.allOf(futures);
            }
        }
        profiler.pop();
    }

    public static void onTickAfter(int i, int to, ProfilerFiller profiler) {
        List<EndTickOperation> endTickOperations;
        boolean levelRunning;
        Minecraft mc = Minecraft.getInstance();
        boolean bl = levelRunning = mc.level != null && mc.player != null && !mc.isPaused();
        if (!ConfigHelper.isTickAsync()) {
            AsyncTicker.tryReload();
            AsyncTicker.tryDebug();
            END_TICK_OPERATIONS.forEach(Runnable::run);
            END_TICK_OPERATIONS.clear();
            if (levelRunning) {
                SEQUENCED_END_TICK_EVENTS.forEach(Runnable::run);
                PARALLEL_END_TICK_EVENTS.forEach(Runnable::run);
            }
            return;
        }
        profiler.push("async_particles");
        if (levelRunning) {
            profiler.push("particle_tick");
            if (i == to - 1) {
                mc.particleEngine.tick();
            } else {
                AsyncTicker.waitForCleanUp();
            }
            profiler.pop();
        }
        if (i != to - 1) {
            return;
        }
        AsyncTicker.tryReload();
        AsyncTicker.tryDebug();
        CompletableFuture<Void> particleFuture = CompletableFuture.runAsync(() -> timeUsageNano.setRelease(System.nanoTime()), EXECUTOR);
        CompletionStage<Void> sequencedTaskFuture = particleFuture;
        CompletionStage<Object> parallelEventsFuture = Utils.NULL_FUTURE;
        CompletionStage<Object> parallelOperationsFuture = Utils.NULL_FUTURE;
        if (levelRunning) {
            sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenRun(() -> {
                for (Runnable runnable : SEQUENCED_END_TICK_EVENTS) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(runnable, e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
            parallelEventsFuture = ((CompletableFuture)particleFuture.thenCompose(v -> {
                CompletableFuture[] completableFutures = new CompletableFuture[PARALLEL_END_TICK_EVENTS.size()];
                int j = 0;
                for (Runnable runnable : PARALLEL_END_TICK_EVENTS) {
                    completableFutures[j++] = CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                        if (!AsyncTicker.isTolerable(e) || EXCEPTION_TRACKER.addException(endTickEvent, (Throwable)e)) {
                            throw ExceptionUtil.toThrowDirectly(e);
                        }
                        return null;
                    });
                }
                return CompletableFuture.allOf(completableFutures);
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        if (!(endTickOperations = END_TICK_OPERATIONS).isEmpty()) {
            EndTickOperation[] endTickTasks = endTickOperations.toArray(new EndTickOperation[0]);
            endTickOperations.clear();
            sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenRun(() -> {
                for (EndTickOperation endTickTask : endTickTasks) {
                    if (!endTickTask.isParallel()) continue;
                    try {
                        endTickTask.run();
                    }
                    catch (Exception e) {
                        if (AsyncTicker.isTolerable(e) && !EXCEPTION_TRACKER.addException(endTickTask.getId(), e)) continue;
                        throw e;
                    }
                }
            })).exceptionally(AsyncTicker::tickExceptionally);
            parallelOperationsFuture = ((CompletableFuture)particleFuture.thenCompose(v -> {
                CompletableFuture[] futures = new CompletableFuture[endTickTasks.length];
                int j = 0;
                for (EndTickOperation endTickTask : endTickTasks) {
                    if (endTickTask.isParallel()) continue;
                    futures[j++] = CompletableFuture.runAsync(endTickTask, EXECUTOR).exceptionally(e -> {
                        if (!AsyncTicker.isTolerable(e) || EXCEPTION_TRACKER.addException(endTickTask.getId(), (Throwable)e)) {
                            throw ExceptionUtil.toThrowDirectly(e);
                        }
                        return null;
                    });
                }
                return j == 0 ? Utils.nullFuture() : CompletableFuture.allOf(Arrays.copyOf(futures, j));
            })).exceptionally(AsyncTicker::tickExceptionally);
        }
        sequencedTaskFuture = CompletableFuture.allOf(new CompletableFuture[]{sequencedTaskFuture, parallelEventsFuture, parallelOperationsFuture});
        List<Runnable> particleOperations = PARTICLE_OPERATIONS;
        if (!particleOperations.isEmpty()) {
            if (!levelRunning) {
                particleOperations.clear();
            } else {
                Runnable[] particleTasks = particleOperations.toArray(new Runnable[0]);
                particleOperations.clear();
                Function<Void, CompletableFuture> function = v -> CompletableFuture.allOf((CompletableFuture[])Arrays.stream(particleTasks).map(runnable -> CompletableFuture.runAsync(runnable, EXECUTOR).exceptionally(e -> {
                    if (!ConfigHelper.markSyncIfTickFailed() && AsyncTicker.isTolerable(e)) {
                        LOGGER.warn("Exception while executing particle operation, you can ignore it if it doesn't happen frequently.", e);
                        return null;
                    }
                    throw ExceptionUtil.toThrowDirectly(e);
                })).toArray(CompletableFuture[]::new));
                sequencedTaskFuture = ((CompletableFuture)((CompletableFuture)sequencedTaskFuture).thenCompose(function)).exceptionally(AsyncTicker::tickExceptionally);
            }
        }
        AsyncTicker.particleFuture = ((CompletableFuture)sequencedTaskFuture).thenRunAsync(() -> timeUsageNano.setRelease(System.nanoTime() - timeUsageNano.getAcquire()), EXECUTOR);
        profiler.pop();
    }

    private static Void tickExceptionally(Throwable e) {
        if (!(e instanceof Exception)) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        Minecraft mc = Minecraft.getInstance();
        if (!AsyncTicker.isTolerable(e) && mc.level != null && mc.player != null) {
            throw ExceptionUtil.toThrowDirectly(e);
        }
        LOGGER.warn("Exception while executing before particle operation", e);
        return null;
    }

    public static boolean isTolerable(@NotNull Throwable e) {
        if (!(e instanceof Exception)) {
            return false;
        }
        Throwable rootCause = ExceptionUtil.getRootCause(e);
        return rootCause instanceof MissingPaletteEntryException || rootCause instanceof NullPointerException || rootCause instanceof IndexOutOfBoundsException || rootCause instanceof ArrayIndexOutOfBoundsException || rootCause instanceof ConcurrentModificationException && ConfigHelper.suppressCME();
    }

    public static void onTickingParticleException(Particle particle, Throwable t) {
        if (ThreadUtil.isOnMainThread()) {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
        boolean tolerable = AsyncTicker.isTolerable(t);
        Class<? extends Particle> particleClass = ((ParticleAddon)particle).asyncparticles$getRealClass();
        if (tolerable && !EXCEPTION_TRACKER.addException(particleClass, t)) {
            return;
        }
        if (ConfigHelper.markSyncIfTickFailed()) {
            ((ParticleAddon)particle).asyncparticles$setTickSync();
            if (!AsyncTicker.shouldSync(particleClass)) {
                if (!tolerable) {
                    LOGGER.warn("Exception while ticking particle {}, marking as sync", (Object)particle, (Object)t);
                } else {
                    LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
                }
                AsyncTicker.markAsSync(particleClass);
            }
            AsyncTicker.recordSync(particle);
        } else if (tolerable) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.displayClientMessage((Component)Component.literal((String)"Exception %s thrown while ticking particle %s exceeds the threshold, please contact the author: ".formatted(t.getClass().getSimpleName(), particleClass)).append((Component)Component.literal((String)"https://github.com/Harveykang/AsyncParticles/issues").setStyle(Style.EMPTY.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(AsyncParticlesClient.ISSUE_URI)).withUnderlined(Boolean.valueOf(true)))), false);
            }
            LOGGER.warn("Exception {} thrown while ticking particle {} exceeds the threshold, please contact the author: {}", (Object)t.getClass().getSimpleName(), (Object)particle, (Object)"https://github.com/Harveykang/AsyncParticles/issues", (Object)t);
        } else {
            throw AsyncTicker.constructCrashReport(particle, t);
        }
    }

    public static void onParticleEngineClear() {
        if (ModListHelper.A_GOOD_PLACE_LOADED) {
            AGoodPlaceCompat.onParticleEngineClear();
        }
        if (ModListHelper.PARTICLERAIN_LOADED) {
            ParticleRainCompat.clearCounters();
        }
    }

    public static void waitForCleanUp() {
        if (particleCleanup != null) {
            particleCleanup.join();
            particleCleanup = null;
        }
    }

    public static ReportedException constructCrashReport(Particle particle, Throwable t) {
        AsyncTicker.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncTicker.tryDebug();
        AsyncRenderer.debugLater(arg_0 -> ((Logger)LOGGER).info(arg_0));
        AsyncRenderer.tryDebug();
        CrashReport crashReport = CrashReport.forThrowable((Throwable)t, (String)"Ticking Particle");
        CrashReportCategory crashReportCategory = crashReport.addCategory("Particle being ticked");
        crashReportCategory.setDetail("Particle", () -> ((Particle)particle).toString());
        crashReportCategory.setDetail("Particle Type", () -> ((ParticleRenderType)particle.getRenderType()).toString());
        return new ReportedException(crashReport);
    }

    public static void tickSyncParticles() {
        if (!shouldTickParticles && ConfigHelper.isTickAsync() || SYNC_PARTICLES.isEmpty()) {
            return;
        }
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        boolean enableLightCache = ConfigHelper.particleLightCache();
        Iterator<Particle> iterator = SYNC_PARTICLES.iterator();
        while (iterator.hasNext()) {
            Particle particle = iterator.next();
            try {
                particleEngine.tickParticle(particle);
                if (!(particle instanceof TrackingEmitter)) {
                    if (enableLightCache) {
                        ((LightCachedParticleAddon)particle).asyncparticles$refresh();
                    }
                    ((ParticleAddon)particle).asyncparticles$setTicked();
                }
            }
            catch (Throwable e) {
                throw AsyncTicker.constructCrashReport(particle, e);
            }
            if (particle.isAlive()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markAsSync(Class<? extends Particle> aClass) {
        Set<Class<? extends Particle>> set = SYNC_PARTICLE_TYPES;
        synchronized (set) {
            SYNC_PARTICLE_TYPES.add(aClass);
        }
    }

    public static boolean shouldSync(Class<?> aClass) {
        return SYNC_PARTICLE_TYPES.contains(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordSync(Particle particle) {
        Set<Particle> set = SYNC_PARTICLES;
        synchronized (set) {
            SYNC_PARTICLES.add(particle);
        }
    }

    public static void onEvicted(Particle particle) {
        particle.getParticleGroup().ifPresent(g -> Minecraft.getInstance().particleEngine.updateCount(g, -1));
        if (particle.isAlive()) {
            particle.remove();
        }
    }

    static void tryDebug() {
        if (debugConsumer == null) {
            return;
        }
        debugConsumer.accept(String.format("[Debug AsyncTicker]\nlast tick duration: %.1f ms,\ninterrupted: %s,\nparticle operations: %d,\nend tick events: %d,\nend tick operations: %d,\nmax particles queue size: %d,\nparticles queue size/allocated: %s,\nparticles to add size: %d\nsync particle count: %d,\nsync particle types: %s,".formatted(ConfigHelper.isTickAsync() ? (double)timeUsageNano.getAcquire() / 1000000.0 : Double.NaN, debug_cancelled, PARTICLE_OPERATIONS.size(), SEQUENCED_END_TICK_EVENTS.size() + PARALLEL_END_TICK_EVENTS.size(), END_TICK_OPERATIONS.size(), ConfigHelper.getParticleLimit(), Minecraft.getInstance().particleEngine.particles.entrySet().stream().collect(Collectors.toMap(e -> ((ParticleRenderType)e.getKey()).name(), e -> {
            Queue queue = (Queue)e.getValue();
            return queue.size() + "/" + ((IterationSafeEvictingQueue)queue).arraySize();
        })), Minecraft.getInstance().particleEngine.particlesToAdd.size(), SYNC_PARTICLES.size(), SYNC_PARTICLE_TYPES.stream().map(Class::getName).toList()), new Object[0]));
        debugConsumer = null;
    }

    public static void debugLater(Consumer<String> consumer) {
        debugConsumer = consumer;
    }

    public static void dumpParticles() {
        LOGGER.info((Object)Minecraft.getInstance().particleEngine.particles);
    }

    public static void reloadLater() {
        shouldReload = true;
    }

    private static void tryReload() {
        if (shouldReload) {
            AsyncTicker.reload(false);
            shouldReload = false;
        }
    }

    public static void reload(boolean clearParticles) {
        AsyncRenderer.reset();
        ParticleEngine particleEngine = Minecraft.getInstance().particleEngine;
        if (clearParticles) {
            AsyncTicker.reset();
            particleEngine.clearParticles();
        } else {
            BusyWaitEvictingQueue<Particle> newToAdd = BusyWaitEvictingQueue.newInstance(1024, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newToAdd.addAll(particleEngine.particlesToAdd);
            particleEngine.particlesToAdd = newToAdd;
            BusyWaitEvictingQueue<TrackingEmitter> newEmitters = BusyWaitEvictingQueue.newInstance(256, ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
            newEmitters.addAll(particleEngine.trackingEmitters);
            particleEngine.trackingEmitters = newEmitters;
            particleEngine.particles.entrySet().forEach(entry -> {
                Queue queue = (Queue)entry.getValue();
                IterationSafeEvictingQueue<Particle> newQueue = IterationSafeEvictingQueue.newInstance(queue.size(), ConfigHelper.getParticleLimit(), AsyncTicker::onEvicted);
                newQueue.addAll(queue);
                if (ConfigHelper.particleLightCache()) {
                    newQueue.forEach(p -> ((LightCachedParticleAddon)p).asyncparticles$refresh());
                }
                entry.setValue(newQueue);
            });
        }
    }

    public static void reset() {
        cancelled = true;
        AsyncTicker.waitForCleanUp();
        if (particleFuture != null) {
            particleFuture.join();
            particleFuture = null;
        }
        PARTICLE_OPERATIONS.clear();
        END_TICK_OPERATIONS.clear();
        SYNC_PARTICLES.clear();
        cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public static void registerEvent(EndTickEvent task) {
        if (task.isParallel()) {
            List<EndTickEvent> list = PARALLEL_END_TICK_EVENTS;
            synchronized (list) {
                PARALLEL_END_TICK_EVENTS.add(task);
                PARALLEL_END_TICK_EVENTS.sort(Comparator.comparingInt(EndTickEvent::getPriority));
            }
        }
        List<EndTickEvent> list = SEQUENCED_END_TICK_EVENTS;
        synchronized (list) {
            SEQUENCED_END_TICK_EVENTS.add(task);
            SEQUENCED_END_TICK_EVENTS.sort(Comparator.comparingInt(EndTickEvent::getPriority));
        }
    }

    @ApiStatus.Internal
    public static void scheduleOperation(EndTickOperation task) {
        if (!shouldTickParticles && ConfigHelper.isTickAsync()) {
            return;
        }
        if (ThreadUtil.isOnMainThread()) {
            END_TICK_OPERATIONS.add(task);
        } else {
            ThreadUtil.enqueueClientTask(() -> END_TICK_OPERATIONS.add(task));
        }
    }

    static {
        SEQUENCED_END_TICK_EVENTS = new ArrayList<EndTickEvent>();
        PARALLEL_END_TICK_EVENTS = new ArrayList<EndTickEvent>();
        END_TICK_OPERATIONS = new ArrayList<EndTickOperation>();
        debug_cancelled = false;
        EXCEPTION_TRACKER = new ExceptionTracker(() -> 5000, ConfigHelper::getTickFailurePerSecondThreshold);
        timeUsageNano = new AtomicLong(0L);
        AtomicInteger workerCount = new AtomicInteger(1);
        int clamp = Mth.clamp((int)(Runtime.getRuntime().availableProcessors() - 1), (int)1, (int)6);
        EXECUTOR = new ForkJoinPool(clamp, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        LOGGER.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        LOGGER.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("AsyncParticleTicker-" + workerCount.getAndIncrement());
            forkJoinWorkerThread.setDaemon(true);
            return forkJoinWorkerThread;
        }, Util::onThreadException, true);
    }
}

