/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.mixin.off_thread_access;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.Map;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.util.ThreadUtil;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundEventListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public class MixinSoundEngine {
    @Shadow
    private boolean loaded;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void injectTick(CallbackInfo ci) {
        ThreadUtil.assertNotParticleThread();
    }

    @WrapMethod(method={"reload", "stopAll", "destroy", "stopAll"})
    public void wrapReload(Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[0]);
        } else {
            ThreadUtil.enqueueClientTask(() -> {
                Void cfr_ignored_0 = (Void)original.call(new Object[0]);
            });
        }
    }

    @WrapMethod(method={"updateCategoryVolume"})
    public void wrapUpdateCategoryVolume(SoundSource category, float volume, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{category, Float.valueOf(volume)});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{category, Float.valueOf(volume)}));
        }
    }

    @WrapMethod(method={"play"})
    public SoundEngine.PlayResult wrapPlay(SoundInstance soundInstance, Operation<SoundEngine.PlayResult> original) {
        if (ThreadUtil.isOnMainThread()) {
            return (SoundEngine.PlayResult)original.call(new Object[]{soundInstance});
        }
        ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{soundInstance}));
        return this.loaded ? SoundEngine.PlayResult.STARTED_SILENTLY : SoundEngine.PlayResult.NOT_STARTED;
    }

    @WrapMethod(method={"addEventListener", "removeEventListener"})
    public void wrapAddEventListener(SoundEventListener listener, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{listener});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{listener}));
        }
    }

    @Redirect(method={"isActive"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;"))
    public Object redirectIsActive(Map<?, Integer> instance, Object o) {
        return instance.getOrDefault(o, Integer.MAX_VALUE);
    }

    @WrapMethod(method={"queueTickingSound"})
    public void wrapQueueTickingSound(TickableSoundInstance tickableSound, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{tickableSound});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{tickableSound}));
        }
    }

    @WrapMethod(method={"requestPreload"})
    public void wrapRequestPreload(Sound sound, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{sound});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{sound}));
        }
    }

    @WrapMethod(method={"playDelayed"})
    public void wrapPlayDelayed(SoundInstance sound, int delay, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{sound, delay});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{sound, delay}));
        }
    }

    @WrapMethod(method={"stop(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/sounds/SoundSource;)V"})
    public void wrapStop(ResourceLocation soundName, SoundSource category, Operation<Void> original) {
        if (ThreadUtil.isOnMainThread()) {
            original.call(new Object[]{soundName, category});
        } else {
            ThreadUtil.enqueueClientTask(() -> original.call(new Object[]{soundName, category}));
        }
    }
}

