/*
 * Decompiled with CFR 0.152.
 */
package fabric.fun.qu_an.minecraft.asyncparticles.client.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class SimplePropertiesConfig {
    public static final Path CONFIG_FILE = Paths.get("config", "asyncparticles.properties");
    private static int limit = 32768;
    public static int renderFailurePerSecondThreshold = 20;
    public static int tickFailurePerSecondThreshold = 5;
    private static boolean asyncClientBlockEntityTick = true;
    private static boolean greedyAsyncClientBlockEntityTick = false;
    private static boolean asyncClientBlockEntityAnimate = true;
    private static boolean forceDoneBlockAnimateTick = false;
    private static boolean forceDoneParticleTick = false;
    private static boolean forceDoneTextureTick = false;
    private static boolean markSyncIfTickFailed = false;
    private static boolean particleLightCache = true;
    private static boolean suppressCME = false;
    private static boolean renderAsync = true;
    private static boolean tickAsync = true;
    private static boolean cullParticles = true;
    private static boolean shouldSave;

    public static void load() throws IOException {
        Properties properties = new Properties();
        if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
            Files.createDirectories(CONFIG_FILE.getParent(), new FileAttribute[0]);
            Files.createFile(CONFIG_FILE, new FileAttribute[0]);
        } else {
            try (InputStream is = Files.newInputStream(CONFIG_FILE, new OpenOption[0]);){
                properties.load(is);
            }
            String verStr = properties.getProperty("version_doNotModify");
            int ver = -1;
            try {
                ver = Integer.parseInt(verStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (ver < 0) {
                properties.setProperty("version_doNotModify", "0");
                asyncClientBlockEntityTick = false;
                properties.setProperty("asyncClientBlockEntityTick", "false");
                shouldSave = true;
            }
        }
        limit = SimplePropertiesConfig.getInt(properties, "limit", 32768);
        renderFailurePerSecondThreshold = SimplePropertiesConfig.getInt(properties, "renderFailurePerSecondThreshold", 20);
        tickFailurePerSecondThreshold = SimplePropertiesConfig.getInt(properties, "tickFailurePerSecondThreshold", 5);
        asyncClientBlockEntityTick = SimplePropertiesConfig.getBoolean(properties, "asyncClientBlockEntityTick", true);
        greedyAsyncClientBlockEntityTick = SimplePropertiesConfig.getBoolean(properties, "greedyAsyncClientBlockEntityTick", false);
        asyncClientBlockEntityAnimate = SimplePropertiesConfig.getBoolean(properties, "asyncClientBlockEntityAnimate", true);
        forceDoneBlockAnimateTick = SimplePropertiesConfig.getBoolean(properties, "forceDoneBlockAnimateTick", false);
        forceDoneParticleTick = SimplePropertiesConfig.getBoolean(properties, "forceDoneParticleTick", false);
        forceDoneTextureTick = SimplePropertiesConfig.getBoolean(properties, "forceDoneTextureTick", false);
        markSyncIfTickFailed = SimplePropertiesConfig.getBoolean(properties, "markSyncIfTickFailed", false);
        particleLightCache = SimplePropertiesConfig.getBoolean(properties, "particleLightCache", true);
        suppressCME = SimplePropertiesConfig.getBoolean(properties, "suppressCME", false);
        renderAsync = SimplePropertiesConfig.getBoolean(properties, "renderAsync", true);
        tickAsync = SimplePropertiesConfig.getBoolean(properties, "tickAsync", true);
        cullParticles = SimplePropertiesConfig.getBoolean(properties, "cullParticles", true);
        if (shouldSave) {
            try (OutputStream os = Files.newOutputStream(CONFIG_FILE, new OpenOption[0]);){
                properties.store(os, null);
            }
            shouldSave = false;
        }
    }

    private static int getInt(Properties properties, String key, int defaultValue) {
        String i = properties.getProperty(key);
        try {
            return Integer.parseInt(i);
        }
        catch (NumberFormatException e) {
            properties.setProperty(key, String.valueOf(defaultValue));
            shouldSave = true;
            return defaultValue;
        }
    }

    private static boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        String b = properties.getProperty(key);
        if (b != null) {
            return Boolean.toString(!defaultValue).equalsIgnoreCase(b) != defaultValue;
        }
        properties.setProperty(key, String.valueOf(defaultValue));
        shouldSave = true;
        return defaultValue;
    }

    public static boolean asyncBlockEntityTick() {
        return asyncClientBlockEntityTick;
    }

    public static boolean greedyAsyncClientBlockEntityTick() {
        return greedyAsyncClientBlockEntityTick;
    }

    public static boolean asyncBlockEntityAnimate() {
        return asyncClientBlockEntityAnimate;
    }

    public static boolean forceDoneBlockAnimateTick() {
        return forceDoneBlockAnimateTick;
    }

    public static boolean forceDoneParticleTick() {
        return forceDoneParticleTick;
    }

    public static boolean forceDoneTextureTick() {
        return forceDoneTextureTick;
    }

    public static boolean markSyncIfTickFailed() {
        return markSyncIfTickFailed;
    }

    public static boolean particleLightCache() {
        return particleLightCache;
    }

    public static boolean suppressCME() {
        return suppressCME;
    }

    public static boolean isRenderAsync() {
        return renderAsync;
    }

    public static boolean isTickAsync() {
        return tickAsync;
    }

    public static boolean isCullParticles() {
        return cullParticles;
    }

    public static int getLimit() {
        return limit;
    }
}

