/*
 * Decompiled with CFR 0.152.
 */
package neoforge.fun.qu_an.minecraft.asyncparticles.client.coremod;

import com.bawnorton.mixinsquared.canceller.MixinCancellerRegistrar;
import java.util.List;
import java.util.Set;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.AsyncparticlesClient;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.compat.ModListHelper;
import neoforge.fun.qu_an.minecraft.asyncparticles.client.coremod.mixin_extension.ExtensionCancelMixinMethod;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class APMixinPlugin
implements IMixinConfigPlugin {
    static final ILogger LOGGER = MixinService.getService().getLogger("asyncparticles:plugin");
    private static final int PACKAGE_LENGTH = AsyncparticlesClient.class.getPackage().getName().length() + ".mixin.".length();

    public void onLoad(String mixinPackage) {
        if (!ModListHelper.IS_CLIENT) {
            return;
        }
        ExtensionCancelMixinMethod.init();
        ExtensionCancelMixinMethod.register(new ExtensionCancelMixinMethod.Canceller(this){

            @Override
            public boolean preTest(String mixinClassName) {
                return switch (mixinClassName) {
                    case "einstein.subtle_effects.mixin.client.particle.ParticleEngineMixin", "net.irisshaders.iris.mixin.fabric.MixinParticleEngine" -> true;
                    default -> false;
                };
            }

            @Override
            public boolean test(String mixinClassName, String mixinMethodName, String mixinMethodDesc, List<String> mixinParameterNames) {
                return switch (mixinClassName) {
                    case "einstein.subtle_effects.mixin.client.particle.ParticleEngineMixin" -> mixinMethodName.equals("shouldRenderParticle");
                    case "net.irisshaders.iris.mixin.fabric.MixinParticleEngine" -> mixinMethodName.equals("iris$cancel");
                    default -> false;
                };
            }
        });
        MixinCancellerRegistrar.register((targetClassNames, mixinClassName) -> switch (mixinClassName) {
            case "net.irisshaders.iris.mixin.forge.MixinLevelRenderer", "net.irisshaders.iris.mixin.fabric.MixinLevelRenderer", "me.fzzyhmstrs.particle_core.mixins.ParticleManagerFrustumMixin", "me.fzzyhmstrs.particle_core.mixins.ParticleManagerRotationMixin", "me.fzzyhmstrs.particle_core.mixins.WorldRendererFrustumMixin", "me.fzzyhmstrs.particle_core.mixins.ParticleManagerCachedLightMixin", "me.fzzyhmstrs.particle_core.mixins.BillboardParticleMixin", "me.fzzyhmstrs.particle_core.mixins.ParticleMixin" -> true;
            default -> false;
        });
    }

    public String getRefMapperConfig() {
        return ModListHelper.IS_FORGE ? null : "fabric-asyncparticles-common-refmap.json";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!ModListHelper.IS_CLIENT) {
            return false;
        }
        String mixinPackageName = mixinClassName.substring(PACKAGE_LENGTH);
        String[] split = mixinPackageName.split("\\.");
        if (split.length == 1) {
            return true;
        }
        return switch (split[0]) {
            case "fabric" -> {
                if (split.length == 2) {
                    if (!ModListHelper.IS_FORGE) {
                        yield true;
                    }
                    yield false;
                }
                switch (split[1]) {
                    case "off_thread_access": {
                        if (!ModListHelper.IS_FORGE) {
                            yield true;
                        }
                        yield false;
                    }
                    case "particlerain": {
                        yield ModListHelper.FABRIC_PARTICLERAIN_LOADED;
                    }
                    case "effective": {
                        yield ModListHelper.FABRIC_EFFECTIVE_LOADED;
                    }
                    case "effectual": {
                        yield ModListHelper.FABRIC_EFFECTUAL_LOADED;
                    }
                    case "particular": {
                        yield ModListHelper.FABRIC_PARTICULAR_LOADED;
                    }
                    case "iris": {
                        yield ModListHelper.FABRIC_IRIS_LOADED;
                    }
                    case "vulkanmod": {
                        yield ModListHelper.FABRIC_VULKAN_MOD_LOADED;
                    }
                }
                throw new IllegalArgumentException("Unknown fabric mixin: " + mixinClassName);
            }
            case "off_thread_access", "tick", "render" -> true;
            case "modernui" -> ModListHelper.MODERN_UI_LOADED;
            case "sodium_0_7" -> {
                if (ModListHelper.SODIUM_LOADED && ModListHelper.versionCheck("sodium", "0.7", "0.8")) {
                    yield true;
                }
                yield false;
            }
            case "iris_like" -> ModListHelper.IRIS_LIKE_LOADED;
            case "a_good_place" -> ModListHelper.A_GOOD_PLACE_LOADED;
            case "subtle_effects" -> {
                if (split.length == 2) {
                    yield ModListHelper.SUBTLE_EFFECTS_LOADED;
                }
                switch (split[1]) {
                    case "fabric": {
                        if (!ModListHelper.IS_FORGE && ModListHelper.FABRIC_SUBTLE_EFFECTS_LOADED) {
                            yield true;
                        }
                        yield false;
                    }
                }
                yield ModListHelper.SUBTLE_EFFECTS_LOADED;
            }
            case "watut" -> ModListHelper.WATUT_LOADED;
            case "physicsmod" -> ModListHelper.PHYSICSMOD_LOADED;
            default -> throw new IllegalArgumentException("Unknown mixin: " + mixinClassName);
        };
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

