/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

struct LensElement {
    float curvature; // Radius of the circle primitive (if negative, element is concave)
    float thickness; // Distance to next element
    float aperture;  // Aperture diameter of the element
	SellmeierCoefficients coefficients;
};

const LensElement doubleGauss[] = LensElement[](
    LensElement( 085.50 * 0.001, 11.6 * 0.001, 76.0 * 0.001, N_LAF2     ),
    LensElement( 408.33 * 0.001, 01.5 * 0.001, 76.0 * 0.001, NULL_COEFFS),
    LensElement( 040.35 * 0.001, 17.0 * 0.001, 66.0 * 0.001, N_BK7HT    ),
    LensElement( 156.05 * 0.001, 03.5 * 0.001, 66.0 * 0.001, F2HT       ),
    LensElement( 025.05 * 0.001, 13.7 * 0.001, 44.0 * 0.001, NULL_COEFFS),
    LensElement( 000.00 * 0.001, 08.3 * 0.001, 42.6 * 0.001, NULL_COEFFS),
    LensElement(-036.80 * 0.001, 03.5 * 0.001, 44.0 * 0.001, N_SF8      ),
    LensElement( 055.00 * 0.001, 23.0 * 0.001, 52.0 * 0.001, N_LAF2     ),
    LensElement(-051.50 * 0.001, 01.0 * 0.001, 52.0 * 0.001, NULL_COEFFS),
    LensElement( 123.50 * 0.001, 17.0 * 0.001, 52.0 * 0.001, N_LAF2     ),
    LensElement(-204.96 * 0.001, 00.0 * 0.001, 52.0 * 0.001, NULL_COEFFS)
);

const LensElement foo[] = LensElement[](
    LensElement( 58.950  * 0.001, 7.520  * 0.001, 50.4 * 0.001, N_BAF10),
    LensElement( 169.660 * 0.001, 0.240  * 0.001, 50.4 * 0.001, NULL_COEFFS    ),
    LensElement( 38.550  * 0.001, 8.050  * 0.001, 46.0 * 0.001, N_BAF10),
    LensElement( 81.540  * 0.001, 6.550  * 0.001, 46.0 * 0.001, N_BAF4 ),
    LensElement( 25.500  * 0.001, 11.410 * 0.001, 36.0 * 0.001, NULL_COEFFS    ),
    LensElement( 0.0     * 0.001, 9.0    * 0.001, 20.2 * 0.001, NULL_COEFFS    ),
    LensElement(-28.990  * 0.001, 2.360  * 0.001, 34.0 * 0.001, F5     ),
    LensElement( 81.540  * 0.001, 12.130 * 0.001, 40.0 * 0.001, N_SSK5 ),
    LensElement(-40.770  * 0.001, 0.380  * 0.001, 40.0 * 0.001, NULL_COEFFS    ),
    LensElement( 874.130 * 0.001, 6.440  * 0.001, 40.0 * 0.001, SF1    ),
    LensElement(-79.460  * 0.001, 0.0 * 0.001, 40.0 * 0.001, NULL_COEFFS    )
);

const LensElement lensSystem[] = foo;
