/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#define STAR_SHAPED_BOKEH 0 // [0 1]

const float bladeAngleOffset = TAU / APERTURE_BLADES;

vec2 cameraBokeh() {
	float currentBlade = randF() * APERTURE_BLADES;

	vec2 rotVec   = sincos(floor(currentBlade) * bladeAngleOffset);
	mat2 rotation = mat2(rotVec.y, -rotVec.x, rotVec.xy);

	#if STAR_SHAPED_BOKEH == 0
		float bokehAngle = bladeAngleOffset * 0.5;
	#else
		float bokehAngle = bladeAngleOffset;
	#endif

	vec2 bokeh = rotation * vec2(cos(bokehAngle), sin(bokehAngle) * (fract(currentBlade) * 2.0 - 1.0));

	float radial = 1.0 - pow(1.0 - sqrt(randF()), 1.1);

	return bokeh * radial;
}

void computeThinLensApproximation(vec2 coords, inout vec3 sensorPosition, inout vec3 viewVector) {
	vec2 focalLength    = sensorSize  * diagonal2(gbufferProjection);
	vec2 fovCorrection  = sensorSize  / focalLength;
	vec2 apertureRadius = focalLength / (F_STOPS * 2.0);

	vec2 antiAliasingOffset = taaOffsets[framemod] * texelSize;
	vec3 sensorRayOrigin    = vec3(((coords * 2.0 - 1.0) + antiAliasingOffset) * fovCorrection, -1.0);

    #if MANUAL_CAMERA == 0
	    vec3 focalDir = mat3(gbufferModelViewInverse) * normalize(vec3(antiAliasingOffset * fovCorrection, -1.0));
        vec3 focalHit = raytraceVoxel(sensorPosition, focalDir, MAX_RAYTRACE_STEPS, true, true).position;

        float focalDistance = max0(distance(focalHit, sensorPosition));
    #else
        float focalDistance = FOCAL;
    #endif

	vec3 aperturePoint = vec3(cameraBokeh() * apertureRadius, 0.0);

	sensorPosition = aperturePoint;
	viewVector     = normalize((sensorRayOrigin * focalDistance) - aperturePoint);
}
