/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#define CACHE_GRID_SIZE ivec3(256, 128, 256)

#define MAX_CACHE_PROBING_ATTEMPTS 8u

#define CACHE_DIM        2048u
#define CACHE_ARRAY_SIZE (CACHE_DIM * CACHE_DIM)

#define MAX_CACHE_SAMPLES       64u
#define MAX_CACHE_TRACE_BOUNCES 2

struct CacheEntry {
    uint packedPosition;
    uint facePosX_A, facePosX_B, counterPosX;
    uint faceNegX_A, faceNegX_B, counterNegX;
    uint facePosY_A, facePosY_B, counterPosY;
    uint faceNegY_A, faceNegY_B, counterNegY;
    uint facePosZ_A, facePosZ_B, counterPosZ;
    uint faceNegZ_A, faceNegZ_B, counterNegZ;
};

layout(std430, binding = 6) restrict buffer radianceCache {
	CacheEntry cacheEntries[];
};
