/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

/*
    [Reference]:
        Hammon, A., Jr. (2017). PBR Diffuse Lighting for GGX+Smith Microsurfaces. https://ubm-twvideo01.s3.amazonaws.com/o1/vault/gdc2017/Presentations/Hammon_Earl_PBR_Diffuse_Lighting.pdf
*/

vec3 hammonDiffuse(Material material, float NdotL, float NdotV, float VdotL, float NdotH) {
    float facing    = 0.5 + 0.5 * VdotL;
    float roughSurf = facing * (0.9 - 0.4 * facing) * (inversesqrt(NdotH * NdotH + 1e-2) + 2.0);

    float energyConservationFactor = 1.0 - (4.0 * sqrt(material.F0) + 5.0 * material.F0 * material.F0) * rcp(9.0);
    vec3 fresnelL = fresnelDielectricDielectric_T(NdotL, airIOR, material.N);
    vec3 fresnelV = fresnelDielectricDielectric_T(NdotV, airIOR, material.N);

    vec3 smoothSurf = (fresnelL * fresnelV) / energyConservationFactor;

    float roughness = material.alpha.r;
    vec3  single    = mix(smoothSurf, vec3(roughSurf), roughness) * RCP_PI;
    float multi     = 0.1159 * roughness;

    return NdotL * (material.albedo * multi + single);
}
