/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

/*
    [Credits]:
        snurf - enormous help with getting ReSTIR GI to work, thanks to them! (https://www.patreon.com/snurf)

	[References]:
		Bitterli B. et al. (2020). Spatiotemporal reservoir resampling for real-time ray tracing with dynamic direct lighting. https://benedikt-bitterli.me/restir/bitterli20restir.pdf
		Ouyang Y. et al. (2021). ReSTIR GI: Path Resampling for Real-Time Path Tracing. https://research.nvidia.com/publication/2021-06_restir-gi-path-resampling-real-time-path-tracing
		Bitterli B. (2022). Correlations and Reuse for Fast and Accurate Physically Based Light Transport. https://digitalcommons.dartmouth.edu/cgi/viewcontent.cgi?article=1080&context=dissertations
*/

#define TEMPORAL_OVERWRITE_THRESHOLD 0

#define NORMAL_THRESHOLD 5.0
#define DEPTH_THRESHOLD  0.2

#define WEIGHT_CLAMP 100.0

#define TEMPORAL_M_CLAMP 20

#define SPATIAL_M_CLAMP              500
#define SPATIAL_REUSE_ITERATIONS       9
#define SPATIAL_NOISE_TILES_SCALE     48
#define SPATIAL_NEIGHBORHOOD_SIZE     32
#define SPATIAL_VISIBILITY_LENIENCE 0.01

#define VISIBILITY_VALIDATION_STEPS 6

#include "/include/fragment/restir/reservoir.glsl"
#include "/include/fragment/restir/integrand.glsl"
