/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

void ReSTIR_Temporal_Reuse(
    inout Reservoir reservoir,
    vec3 prevPosition,
    Material material,
    vec3 visiblePosition,
    vec3 visibleNormal,
    float depth
) {
	if(saturate(prevPosition.xy) == prevPosition.xy) {
        ivec2 prevCoords = ivec2(prevPosition.xy * viewSize);

        Reservoir prevReservoir = readTemporalReservoirPrevious(prevCoords);

        if (prevReservoir.age > 0u) {
			vec3  prevVisibleNormal = decodeUnitVector((uvec2(texture(NORMAL_BUFFER, prevPosition.xy).r) >> uvec2(0, 16) & 65535u) * rcpMaxFloat16);
			float prevDepth         = exp2(texture(MOMENTS_BUFFER, prevPosition.xy).a);

			if(isGeometricallySimilar(visibleNormal, prevVisibleNormal, depth, prevDepth)) {
				prevReservoir.age = min(prevReservoir.age, TEMPORAL_M_CLAMP);

				vec3 prevVisiblePosition = readVisiblePositionPrevious(prevCoords);

				float jacobian = computeJacobianDeterminant(prevReservoir.position, prevReservoir.normal, visiblePosition, prevVisiblePosition);

				float p_hat  = luminance(prevReservoir.radiance * computeDiffusePDF(prevReservoir.position, material, visiblePosition, visibleNormal));
				      p_hat *= jacobian;

				mergeReservoir(reservoir, prevReservoir, p_hat * prevReservoir.weight * prevReservoir.age);
			}
		}
	}

	float p_hat = luminance(reservoir.radiance * computeDiffusePDF(reservoir.position, material, visiblePosition, visibleNormal));
	finalizeReservoir(reservoir, p_hat);

	writeTemporalReservoirCurrent(reservoir, ivec2(gl_FragCoord.xy));
}
