/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

void rainPuddles(inout Material material, float waterF0, vec3 position, vec3 geometricNormal) {
	if(wetness > 0.0) {
		vec2 puddleCoords = (position.xz * 0.5 + 0.5) * (1.0 - RAIN_PUDDLES_SIZE);

		float puddle  = saturate(FBM(puddleCoords, 3, 1.0) * 0.5 + 0.5);
	  		  puddle *= (1.0 - material.porosity);
			  puddle *= wetness;
			  puddle *= quinticStep(0.89, 0.99, geometricNormal.y);
			  puddle  = saturate(puddle);
	
		material.F0     = clamp(material.F0 + waterF0 * puddle, 0.0, mix(1.0, 229.5 * rcpMaxFloat8, float(material.F0.r * maxFloat8 <= 229.5)));
		material.alpha  = mix(material.alpha, vec2(EPS), puddle);
		material.normal = mix(material.normal, geometricNormal, puddle);
	}
}
