/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#if RENDER_MODE == 0
    const float exposureBias = 1.0;

    float minExposure = 6e-5;
    float maxExposure = 3e-2;
#else
    const float exposureBias = 1.0;

    float minExposure = 1.0 * exposureBias / luminance(sunIrradiance);
    float maxExposure = 0.1 * exposureBias / luminance(moonIrradiance);
#endif

float computeEV100fromLuminance(float luminance) {
    return log2(luminance * sensorSensitivity * exposureBias / calibration);
}

float computeExposureFromEV100(float ev100) {
    return exp2(-ev100);
}

/*
float computeAutomaticISO(float ev100) {
    return sensorSensitivity / (SHUTTER_SPEED * pow2(F_STOPS)) * exp2(ev100);
}
*/

float computeExposure(float averageLuminance) {
    #if MANUAL_CAMERA == 1 || EXPOSURE == 0
        float ev100    = log2(pow2(F_STOPS) / (1.0 / SHUTTER_SPEED) * sensorSensitivity / ISO);
        float exposure = computeExposureFromEV100(ev100);
    #else
        float ev100	   = computeEV100fromLuminance(averageLuminance);
        float exposure = computeExposureFromEV100(ev100);

        // iso = computeAutomaticISO(ev100);
    #endif

    return clamp(exposure, minExposure, maxExposure);
}
