/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 shadowLightPosition;
uniform vec3 shadowVec;
uniform vec3 sunVector;
uniform vec3 moonVector;
uniform vec3 shadowLightVector;
uniform vec3 cameraPosition;
uniform vec3 upPosition;
uniform vec3 skyColor;

uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform vec2 viewSize;
uniform vec2 texelSize;
uniform ivec2 atlasSize;

uniform int framemod;
uniform int frameCounter;
uniform float frameTime;
uniform float frameTimeCounter;
uniform float centerDepthSmooth;
uniform float near;
uniform float far;
uniform int isEyeInWater;
uniform int hideGUI;
uniform int heldItemId;
uniform float rainStrength;
uniform float wetness;
uniform float sunAngle;
uniform int worldTime;
uniform int worldDay;

uniform int biome_category;
uniform int biome_precipitation;

uniform float biome_arid;
uniform float biome_may_rain;
uniform float biome_may_sandstorm;

uniform sampler2D normals;
uniform sampler2D specular;
uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex5;
uniform usampler2D colortex6;
uniform sampler2D colortex7;
uniform sampler2D colortex8;
uniform sampler2D colortex11;
uniform sampler2D colortex12;
uniform sampler2D colortex13;
uniform sampler2D colortex15;

#if RENDER_MODE == 0
    uniform usampler2D colortex14;
#endif

uniform sampler1D noisetex;

uniform sampler2D depthtex0;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;

uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform vec3 previousCameraPosition;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;

const int noiseTextureResolution = 128;

// Maximum values for x amount of bits (2^x - 1)
const float maxFloat8     = 255.0;
const float maxFloat10    = 1023.0;
const float maxFloat15    = 32767.0;
const float maxFloat16    = 65535.0;
const float rcpMaxFloat8  = 1.0 / maxFloat8;
const float rcpMaxFloat6  = 1.0 / (pow(2.0, 6.0) - 1.0);
const float rcpMaxFloat7  = 1.0 / (pow(2.0, 7.0) - 1.0);
const float rcpMaxFloat15 = 1.0 / maxFloat15;
const float rcpMaxFloat16 = 1.0 / maxFloat16;

const float maxFloat32 = pow(2.0, 32.0) - 1.0;
const float rcpMaxFloat32 = 1.0 / maxFloat32;

const float handDepth = MC_HAND_DEPTH * 0.5 + 0.5;
