/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#define VOXEL_DIM 4096u

const uint VOXEL_ARRAY_SIZE        = VOXEL_DIM * VOXEL_DIM;
const uint VOXEL_LOD_4_ARRAY_SIZE  = VOXEL_ARRAY_SIZE       / 32;
const uint VOXEL_LOD_16_ARRAY_SIZE = VOXEL_LOD_4_ARRAY_SIZE / 32;

struct Voxel {
	uint packedData;
	uint packedPosition;
	uint packedTileData;
};

const Voxel emptyVoxel = Voxel(0u, 0u, 0u);

layout (std430, binding = 0) restrict buffer voxelBuffer {
	Voxel voxelArray[];
};

layout (std430, binding = 1) restrict buffer lodBuffer {
	uint lodArray[];
};
