/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

layout(local_size_x = 16, local_size_y = 16) in;

const ivec3 workGroups = ivec3(256, 256, 1);

#include "/include/voxels/common.glsl"

#include "/include/fragment/cache/common.glsl"

void main() {
    uint index = gl_GlobalInvocationID.x + gl_GlobalInvocationID.y * VOXEL_DIM;

	voxelArray[index] = emptyVoxel;

    if (index < CACHE_ARRAY_SIZE) {
        cacheEntries[index].packedPosition = 0u;
        cacheEntries[index].facePosX_A     = 0u;
        cacheEntries[index].faceNegX_A     = 0u;
        cacheEntries[index].facePosY_A     = 0u;
        cacheEntries[index].faceNegY_A     = 0u;
        cacheEntries[index].facePosZ_A     = 0u;
        cacheEntries[index].faceNegZ_A     = 0u;
    }

    if (index < VOXEL_LOD_4_ARRAY_SIZE + VOXEL_LOD_16_ARRAY_SIZE) {
        lodArray[index] = ~0u;
    }
}
