/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

layout(local_size_x = 16, local_size_y = 16) in;

const ivec3 workGroups = ivec3(256, 256, 1);

#include "/include/fragment/cache/common.glsl"

void main() {
    uint idx = gl_GlobalInvocationID.x + gl_GlobalInvocationID.y * CACHE_DIM;
    if (idx >= CACHE_ARRAY_SIZE) return;

    CacheEntry entry = cacheEntries[idx];

    entry.facePosX_B = entry.facePosX_A;
    entry.faceNegX_B = entry.faceNegX_A;
    entry.facePosY_B = entry.facePosY_A;
    entry.faceNegY_B = entry.faceNegY_A;
    entry.facePosZ_B = entry.facePosZ_A;
    entry.faceNegZ_B = entry.faceNegZ_A;

    cacheEntries[idx] = entry;
}
