/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#include "/settings.glsl"

#if RENDER_MODE == 0

    layout(local_size_x = 4, local_size_y = 4, local_size_z = 4) in;

    const ivec3 workGroups = ivec3(64, 32, 64);

    #include "/include/common.glsl"

    #include "/include/voxels/voxelization.glsl"
    #include "/include/materials/material.glsl"
    #include "/include/voxels/raytracer.glsl"

    #include "/include/atmospherics/constants.glsl"
    #include "/include/atmospherics/illuminance_ssbo.glsl"

    #include "/include/fragment/shadowmap.glsl"

    #include "/include/fragment/belmu/fresnel.glsl"
    #include "/include/fragment/belmu/brdf.glsl"

    #include "/include/fragment/cache/irradiance_cache.glsl"

    const ivec3 faceNormals[7] = ivec3[7](
        ivec3( 0,  0,  0), // dummy
        ivec3( 1,  0,  0), // +X
        ivec3(-1,  0,  0), // -X
        ivec3( 0,  1,  0), // +Y
        ivec3( 0, -1,  0), // -Y
        ivec3( 0,  0,  1), // +Z
        ivec3( 0,  0, -1)  // -Z
    );

    void main() {
        ivec3 gid = ivec3(gl_GlobalInvocationID.xyz);

        if(any(greaterThanEqual(gid, CACHE_GRID_SIZE))) return;

        ivec3 worldPosition = ivec3(floor(gid - ivec3(CACHE_GRID_SIZE / 2) + vec3(0.5) + cameraPosition));

        if (!isInVoxelBounds(worldPosition)) return;
        if (readVoxel(worldPosition) == emptyVoxel) return;

        vec3 voxelCenter = worldPosition + vec3(0.5); 

        for (uint face = 0u; face < faceNormals.length(); face++) {
            ivec3 normal = faceNormals[face];

            ivec3 neighbourVoxel = ivec3(floor(voxelCenter + normal * 0.51));

            if (face > 0u && readVoxel(neighbourVoxel) != emptyVoxel) continue;

            traceCacheRay(voxelCenter, normal, murmurHash13(uvec3(gid + face ^ frameCounter)));
        }
    }

#else

    layout(local_size_x = 1) in;
    const ivec3 workGroups = ivec3(1, 1, 1);

    void main() {
        return;
    }

#endif
