/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#include "/settings.glsl"

#include "/include/uniforms.glsl"
#include "/include/utility/math.glsl"
#include "/include/utility/color.glsl"

#if defined STAGE_VERTEX

    uniform sampler2D colortex2;

    out float averageLuminance;
    out vec2 textureCoords;

    #if MANUAL_CAMERA == 0 && EXPOSURE == 2
        uniform usampler1D histogramSampler;
    #endif

    void main() {
        gl_Position   = vec4(gl_Vertex.xy * 2.0 - 1.0, 1.0, 1.0);
        textureCoords = gl_Vertex.xy;

        #if MANUAL_CAMERA == 0 && EXPOSURE > 0
            #if EXPOSURE == 1
                averageLuminance = luminance(texture(BLOOM_BUFFER, vec2(0.25)).rgb);
            #else
                averageLuminance = uintBitsToFloat(texelFetch(histogramSampler, 0, 0).r);
            #endif

            float previousLuminance = texture(HISTORY_BUFFER, vec2(0.0)).a;
                  previousLuminance = previousLuminance > 0.0 ? previousLuminance : averageLuminance;
                  previousLuminance = isnan(previousLuminance) || isinf(previousLuminance) ? averageLuminance : previousLuminance;

            float exposureSpeed = averageLuminance < previousLuminance ? EXPOSURE_GROWTH : EXPOSURE_DECAY;

            averageLuminance = mix(averageLuminance, previousLuminance, exp(-exposureSpeed * frameTime));
        #endif
    }

#elif defined STAGE_FRAGMENT

    /* RENDERTARGETS: 2 */

    layout (location = 0) out vec4 history;

    in float averageLuminance;
    in vec2 textureCoords;

    #if TAA == 1 && RENDER_MODE == 0
        #include "/include/post/exposure.glsl"
    #endif

    void main() {
        history.rgb = texture(MAIN_BUFFER, textureCoords).rgb;

        #if TAA == 1 && RENDER_MODE == 0
            history.rgb *= computeExposure(averageLuminance);
            history.rgb  = reinhard(history.rgb);
        #endif

        #if MANUAL_CAMERA == 0 && EXPOSURE > 0
            history.a = averageLuminance;
        #endif
    }
    
#endif
