/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#include "/settings.glsl"

#if RENDER_MODE == 0 && RESTIR_GI == 1 && DEBUG_ALBEDO == 0 && DEBUG_NORMALS == 0 && DEBUG_HIT_POSITION == 0

	#if defined STAGE_VERTEX

		out vec2 textureCoords;

		void main() {
			textureCoords = gl_Vertex.xy;
			gl_Position   = vec4(gl_Vertex.xy * 2.0 - 1.0, 1.0, 1.0);
		}

	#elif defined STAGE_FRAGMENT

		#include "/include/common.glsl"

		#include "/include/voxels/voxelization.glsl"

		#include "/include/materials/material.glsl"

		#include "/include/fragment/belmu/fresnel.glsl"
		#include "/include/fragment/belmu/brdf.glsl"

    	#include "/include/fragment/restir/spatial_reuse.glsl"
		
	#endif

#else
	#include "/programs/discard.glsl"
#endif
