/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#if defined STAGE_VERTEX

    out vec2 textureCoords;
    out vec4 vertexColor;

    void main() {
        gl_Position   = ftransform();
	    textureCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
        vertexColor   = gl_Color;
    }

#elif defined STAGE_FRAGMENT

	/* RENDERTARGETS: 15 */

	layout (location = 0) out vec4 color;

	in vec2 textureCoords;
    in vec4 vertexColor;

	uniform sampler2D gtexture;

    #include "/settings.glsl"

	void main() {
        vec4 albedo = texture(gtexture, textureCoords);
		if(albedo.a < 0.102) discard;

        #if WHITE_WORLD == 1
            albedo.rgb = vec3(1.0);
        #endif
        
        color = albedo * vertexColor;
	}
#endif
