/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#if defined STAGE_VERTEX

    out vec2 textureCoords;

    void main() {
        gl_Position   = ftransform();
	    textureCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

		// Thanks Niemand for the nametag fix
		if(gl_Color.a >= 0.24 && gl_Color.a < 0.255) {
			gl_Position = vec4(10.0, 10.0, 10.0, 1.0);
		}
    }

#elif defined STAGE_FRAGMENT

	/* RENDERTARGETS: 15 */

	layout (location = 0) out vec4 color;

	in vec2 textureCoords;
	in mat3 tbn;

    uniform vec4 entityColor;
	uniform sampler2D gtexture;

	void main() {
        vec4 albedo = texture(gtexture, textureCoords);
		if(albedo.a < 0.102) discard;

		#if WHITE_WORLD == 1
            albedo.rgb = vec3(1.0);
        #endif

		color.rgb = mix(albedo.rgb, entityColor.rgb, entityColor.a);
        color.a   = albedo.a;
	}
#endif
