/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#include "/settings.glsl"

#if RENDER_MODE == 1
    #include "/programs/discard.glsl"

#else
    #if defined STAGE_VERTEX

        out vec2 textureCoords;
        out vec4 vertexColor;

        void main() {
            gl_Position   = ftransform();
	        textureCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
            vertexColor   = gl_Color;
        }

    #elif defined STAGE_FRAGMENT

	    /* RENDERTARGETS: 15 */

	    layout (location = 0) out vec4 color;

	    in vec2 textureCoords;
        in vec4 vertexColor;

	    uniform sampler2D gtexture;

	    void main() {
            vec4 albedo = texture(gtexture, textureCoords);
		    if(albedo.a < 0.102) discard;

		    color = albedo * vertexColor;
        }
    #endif
#endif
