/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#if defined STAGE_VERTEX

    #define attribute in
	attribute vec2 mc_midTexCoord;
	attribute vec3 mc_Entity;
    attribute vec4 at_tangent;

	out VertexData {
		flat int blockId;
		vec2 textureCoords;

		#if POM > 0 && defined PROGRAM_TERRAIN
			vec2 texSize;
			vec2 botLeft;
		#endif

		vec3 viewPosition;
		vec4 vertexColor;
		mat3 tbn;
	} vs;

	#include "/include/uniforms.glsl"

	#include "/include/utility/rng.glsl"

    void main() {
        gl_Position = ftransform();

		#if RENDER_MODE == 1 || DEBUG_ALBEDO == 1 || DEBUG_NORMALS == 1 || DEBUG_HIT_POSITION == 1
			return;
		#endif

        vs.textureCoords = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
	    vs.vertexColor   = gl_Color;

		#if POM > 0 && defined PROGRAM_TERRAIN
			vec2 halfSize = abs(vs.textureCoords - mc_midTexCoord);
			vs.texSize    = halfSize * 2.0;
			vs.botLeft    = mc_midTexCoord - halfSize;
		#endif

	    #if !defined PROGRAM_BASIC
			vs.viewPosition = mat3(gl_ModelViewMatrix) * gl_Vertex.xyz + gl_ModelViewMatrix[3].xyz;

    	    vs.tbn[2] = mat3(gbufferModelViewInverse) * normalize(gl_NormalMatrix * gl_Normal);
    	    vs.tbn[0] = mat3(gbufferModelViewInverse) * normalize(gl_NormalMatrix * at_tangent.xyz);
		    vs.tbn[1] = cross(vs.tbn[0], vs.tbn[2])   * sign(at_tangent.w);
	    #endif

        #if defined PROGRAM_ENTITY
		    // Thanks Kneemund for the nametag fix
		    if(gl_Color.a >= 0.24 && gl_Color.a < 0.255) {
			    gl_Position = vec4(10.0, 10.0, 10.0, 1.0);
		    }
            return;
	    #endif

		#if TAA == 1
			gl_Position.xy += taaJitter(gl_Position.w);
		#endif

	    vs.blockId = int(mc_Entity.x);
    }

#elif defined STAGE_FRAGMENT

	#if RENDER_MODE == 0
		/* RENDERTARGETS: 14 */

		layout (location = 0) out uvec4 data;
	#endif

	in VertexData {
		flat int blockId;
		vec2 textureCoords;

		#if POM > 0 && defined PROGRAM_TERRAIN
			vec2 texSize;
			vec2 botLeft;
		#endif

		vec3 viewPosition;
		vec4 vertexColor;
		mat3 tbn;
	} vs;

	#if defined PROGRAM_ENTITY
		uniform vec4 entityColor;
	#endif

	#if RENDER_MODE == 0
		#include "/include/common.glsl"

		#include "/include/voxels/voxelization.glsl"
	
		#include "/include/materials/material.glsl"

		#if POM > 0 && defined PROGRAM_TERRAIN
			#include "/include/fragment/parallax.glsl"
		#endif
	#endif

	uniform sampler2D gtexture;

	void main() {
		#if RENDER_MODE == 0 && DEBUG_ALBEDO == 0 && DEBUG_NORMALS == 0 && DEBUG_HIT_POSITION == 0
			vec2 coords = vs.textureCoords;

			float parallaxSelfShadowing = 1.0;

			#if POM > 0 && defined PROGRAM_TERRAIN
				mat2 texDeriv = mat2(dFdx(coords), dFdy(coords));

				#if POM_DEPTH_WRITE == 1
					gl_FragDepth = gl_FragCoord.z;
				#endif

				if(length(viewToScene(vs.viewPosition)) < POM_DISTANCE) {
					float height = 1.0, traceDistance = 0.0;
					vec2  shadowCoords = vec2(0.0);

					if(texture(normals, coords).a < 1e-3 || texture(gtexture, coords).a < 0.102) discard;

					coords = parallaxMapping(vs.viewPosition, texDeriv, height, shadowCoords, traceDistance);

					if(saturate(coords) != coords) return;

					#if POM_SHADOWING == 1
						parallaxSelfShadowing = parallaxShadowing(shadowCoords, height, texDeriv);
					#endif

					#if POM_DEPTH_WRITE == 1
						gl_FragDepth = projectDepth(unprojectDepth(gl_FragCoord.z) + traceDistance * POM_DEPTH);
					#endif
				}
			#endif

			vec4 albedoTexture = texture(gtexture, coords);
			if(albedoTexture.a < 0.102) discard;

			vec4 normalTexture = texture(normals, coords);

			#if !defined PROGRAM_TEXTURED
				vec4 specularTexture = texture(specular, coords);
			#else
				vec4 specularTexture = vec4(0.0);
			#endif

			albedoTexture *= vs.vertexColor;

        	Material material;
			
            material.albedo  = albedoTexture.rgb;
            material.opacity = albedoTexture.a;

            material.normal = vs.tbn[2];

		    #ifndef PROGRAM_BLOCK
			    if(all(greaterThan(normalTexture, vec4(EPS)))) {
				    material.normal.xy = normalTexture.xy * 2.0 - 1.0;
				    material.normal.z  = sqrt(1.0 - saturate(dot(material.normal.xy, material.normal.xy)));
				    material.normal    = vs.tbn * material.normal;
			    }
		    #endif

		    material.F0 		= specularTexture.g;
		    material.ao 		= normalTexture.b;
		    material.alpha  	= vec2(maxEps(pow2(saturate(1.0 - specularTexture.r))));
		    material.emission   = specularTexture.a * 255.0 < 254.5 ? specularTexture.a : 0.0;
		    material.subsurface = specularTexture.b * 255.0 < 65.0  ? 0.0 : specularTexture.b;
			
        	#if HARDCODED_EMISSIVES == 1
            	if(isEmissive(vs.blockId)) material.emission = 1.0;
        	#endif

			#if defined PROGRAM_ENTITY
				material.albedo = mix(albedoTexture.rgb, entityColor.rgb, entityColor.a);
			
				material.ao = all(lessThanEqual(normalTexture.rgb, vec3(EPS))) ? 1.0 : material.ao;
			#endif

			#if defined PROGRAM_BEACONBEAM
				if(albedoTexture.a <= 1.0 - EPS) discard;
				material.emission = 1.0;
			#endif

			vec4 labPbrData0 = vec4(material.ao, material.emission, material.F0, material.subsurface);
			vec4 labPbrData1 = vec4(material.albedo, material.alpha.r);
			vec4 labPbrData2 = vec4(parallaxSelfShadowing, float(isTranslucent(vs.blockId)), encodeUnitVector(vs.tbn[2]));
			vec2 encNormal   = encodeUnitVector(normalize(material.normal));

			labPbrData2.zw *= maxFloat15;

			uvec4 shiftedData0  = uvec4(round(labPbrData0 * maxFloat8 )) << uvec4(0, 8 , 16, 24);
			uvec4 shiftedData1  = uvec4(round(labPbrData1 * maxFloat8 )) << uvec4(0, 8 , 16, 24);
			uvec4 shiftedData2  = uvec4(round(labPbrData2             )) << uvec4(0, 1 , 2 , 17);
			uvec2 shiftedNormal = uvec2(round(encNormal   * maxFloat16)) << uvec2(0, 16        );

			data.x = shiftedData0.x  | shiftedData0.y | shiftedData0.z | shiftedData0.w;
			data.y = shiftedData1.x  | shiftedData1.y | shiftedData1.z | shiftedData1.w;
			data.z = shiftedData2.x  | shiftedData2.y | shiftedData2.z | shiftedData2.w;
			data.w = shiftedNormal.x | shiftedNormal.y;
		#endif
    }
#endif
