/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#if defined STAGE_VERTEX

    out vec2 textureCoords;
    out vec4 vertexColor;

	#include "/settings.glsl"
    #include "/include/common.glsl"

    void main() {
	    textureCoords = gl_MultiTexCoord0.xy;
	    vertexColor   = gl_Color;

	    vec3 worldPos 	  = transform(gbufferModelViewInverse, transform(gl_ModelViewMatrix, gl_Vertex.xyz));
			 worldPos.xz += RAIN_DIRECTION * worldPos.y;
	
	    gl_Position = transform(gbufferModelView, worldPos).xyzz * diagonal4(gl_ProjectionMatrix) + gl_ProjectionMatrix[3];
    }

#elif defined STAGE_FRAGMENT

	/* RENDERTARGETS: 15 */

	layout (location = 0) out vec4 color;

	in vec2 textureCoords;
    in vec4 vertexColor;

	uniform sampler2D gtexture;

	void main() {
        vec4 albedo = texture(gtexture, textureCoords);
		if(albedo.a < 0.102) discard;

		color = vec4(0.706, 0.878, 0.98, 0.2);
	}
#endif
