/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#include "/settings.glsl"
#include "/include/internal_settings.glsl"

#if RENDER_MODE == 1 || DEBUG_ALBEDO == 1 || DEBUG_NORMALS == 1 || DEBUG_HIT_POSITION == 1 || !defined WORLD_OVERWORLD
    #include "/programs/discard.glsl"
#else
    #if defined STAGE_VERTEX

        out vec2 textureCoords;

        void main() {
		    textureCoords = gl_Vertex.xy;
		    gl_Position   = vec4(gl_Vertex.xy * 2.0 - 1.0, 1.0, 1.0);
        }

    #elif defined STAGE_FRAGMENT

        /* RENDERTARGETS: 4 */

        layout (location = 0) out vec3 sky;

        in vec2 textureCoords;

        #include "/include/common.glsl"
        
        #include "/include/atmospherics/rgb_atmosphere.glsl"
        
        #include "/include/atmospherics/illuminance_ssbo.glsl"

        void main() {
            vec3 skyRay = normalize(unprojectSphere(textureCoords));
                 sky    = evaluateAtmosphericScattering(skyRay, skyIlluminance);
        }
        
    #endif
#endif
