/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#include "/settings.glsl"

layout(local_size_x = 1) in;
const ivec3 workGroups = ivec3(1, 1, 1);

#if RENDER_MODE == 1 || DEBUG_ALBEDO == 1 || DEBUG_NORMALS == 1 || DEBUG_HIT_POSITION == 1

    void main() {
        return;
    }

#else

    #include "/include/common.glsl"

    #include "/include/atmospherics/illuminance_ssbo.glsl"

    #include "/include/atmospherics/rgb_atmosphere.glsl"

    void main() {
        directIlluminance = evaluateDirectIlluminance();
        skyIlluminance    = evaluateUniformSkyIrradiance();
    }
        
#endif
