/***********************************************/
/*           Copyright (c) 2025 Belmu          */
/*             All Rights Reserved             */
/***********************************************/

#define ABOUT 		0 // [0 1]
#define RENDER_MODE 0 // [0 1]

//////////////////////////////////////////////////////////
/*---------------------- BUFFERS -----------------------*/
//////////////////////////////////////////////////////////

#define MAIN_BUFFER        colortex0

#define HISTORY_BUFFER     colortex2

#define LIGHTING_BUFFER    colortex1
#define IRRADIANCE_BUFFER  colortex3

#define ATMOSPHERE_BUFFER  colortex4
#define CLOUDS_BUFFER      colortex5

#define NORMAL_BUFFER      colortex6

#define MOMENTS_BUFFER     colortex12

#define BLOOM_BUFFER       colortex13

#define RASTER_DATA_BUFFER colortex14
#define RASTER_BUFFER      colortex15

//////////////////////////////////////////////////////////
/*------------------------ MATH ------------------------*/
//////////////////////////////////////////////////////////

const float EPS = 1e-5;

const float FLT_MAX = 1e35;

const float PI           = radians(180.0);
const float HALF_PI      = PI * 0.5;
const float RCP_PI       = 1.0 / PI;
const float TAU          = PI * 2.0;
const float INV_SQRT_TAU = 1.0 / sqrt(TAU);

const float SQRT_2		= sqrt(2.0);
const float INV_SQRT_2	= 1.0 / SQRT_2;

const float GOLDEN_ANGLE = PI * (3.0 - sqrt(5.0));
const float GOLDEN_RATIO = sqrt(5.0) * 0.5 + 0.5;

const float deg_to_rad = PI / 180.0;

//////////////////////////////////////////////////////////
/*---------------------- LIGHTING ----------------------*/
//////////////////////////////////////////////////////////

#define RENDER_SCALE 100 // [25 50 75 100]

#define RENDER_ENTITIES 1 // [0 1]

//////////////////////////////////////////////////////////
/*-------------------- PATH TRACING --------------------*/
//////////////////////////////////////////////////////////

#define CHECKERBOARD_RENDERING 0 // [0 1]

#define MAX_LENS_SCATTERING_ORDERS 32

#define MAX_PT_SAMPLES      1  // [1 2 3 4]
#define MAX_PT_BOUNCES      1  // [1 2 3 4 5 6 7 8 9 10 11 12 24 32 64 9999]
#define MAX_PT_BOUNCE_STEPS 64 // [10 16 32 48 64 80 96 112 128 256 512]
#define MAX_PT_SHADOW_STEPS 6  // [2 4 6 8 10 12 16 18 20 22 24 26 28 30 32]

#define MAX_BSDF_SCATTERING_ORDERS 32 // [1 2 4 6 8 16 24 32 64 128]
#define MAX_MBMN_SCATTERING_ORDERS 10

#define RUSSIAN_ROULETTE 1

//////////////////////////////////////////////////////////
/*---------------------- SHADOWS -----------------------*/
//////////////////////////////////////////////////////////

const int   shadowMapResolution = 2048; // [512 1024 2048 3072 4096 6144 8192 10240 16384]
const float shadowDistance      = 128;  // [64 128 256 512 1024 2048 4096]

#define SHADOWS     1 // [0 1]
#define SHADOW_TYPE 1 // [0 1 2]

#define SHADOW_SAMPLES          8 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16]
#define SHADOW_DISTORTION    0.88
#define SHADOW_DEPTH_STRETCH 0.25

#define NORMAL_SHADOW_PENUMBRA 1.0
#define MIN_SHADOW_PENUMBRA    0.7

// Soft Shadows
#define BLOCKER_SEARCH_SAMPLES   8
#define BLOCKER_SEARCH_RADIUS 30.0
#define LIGHT_SIZE            70.0

//////////////////////////////////////////////////////////
/*-------------------- VOXELIZATION --------------------*/
//////////////////////////////////////////////////////////

#define MAX_RAYTRACE_STEPS 16 // [2 4 6 8 10 12 16 18 20 22 24 26 28 30 32]

//////////////////////////////////////////////////////////
/*---------------------- DENOISER ----------------------*/
//////////////////////////////////////////////////////////

#define ATROUS_FILTER         0 // [0 1]
#define TEMPORAL_ACCUMULATION 1 // [0 1]
#define RESTIR_GI             1 // [0 1]

#define VARIANCE_STABILIZATION_THRESHOLD 4.0
#define MIN_FRAMES_LUMINANCE_WEIGHT      4.0

#define LUMINANCE_DIFFERENCE_THRESHOLD 60.0

#define TEMPORAL_NORMAL_SIGMA 16.0
#define TEMPORAL_DEPTH_SIGMA   8.0

#define MAX_ACCUMULATED_FRAMES 20

#define ATROUS_STEP_SIZE             16.0 // [2.0 4.0 6.0 8.0 12.0 16.0 20.0 24.0 28.0 32.0]
#define ATROUS_NORMAL_WEIGHT_SIGMA   16.0 // [4.0 8.0 16.0 32.0 48.0 64.0 80.0 128.0]
#define ATROUS_DEPTH_WEIGHT_SIGMA     1.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0]
#define ATROUS_LUMINANCE_WEIGHT_SIGMA 4.0 // [1.0 2.0 3.0 4.0 5.0 6.0 7.0 8.0 9.0 10.0 11.0 12.0 13.0 14.0 15.0 16.0 17.0 18.0 19.0 20.0 21.0 22.0 23.0 24.0 25.0 26.0 27.0 28.0 29.0 30.0 31.0 32.0 33.0 34.0 35.0 36.0 37.0 38.0 39.0 40.0 41.0 42.0 43.0 44.0 45.0 46.0 47.0 48.0 49.0 50.0 51.0 52.0 53.0 54.0 55.0 56.0 57.0 58.0 59.0 60.0 61.0 62.0 63.0 64.0 65.0 66.0 67.0 68.0 69.0 70.0 71.0 72.0 73.0 74.0 75.0 76.0 77.0 78.0 79.0 80.0 81.0 82.0 83.0 84.0 85.0 86.0 87.0 88.0 89.0 90.0 91.0 92.0 93.0 94.0 95.0 96.0 97.0 98.0 99.0 100.0]

//////////////////////////////////////////////////////////
/*----------------------- TERRAIN ----------------------*/
//////////////////////////////////////////////////////////

#define SPHERES_MODE 1 // [0 1]

#define METAL_SPHERE_ROUGHNESS 2e-2
#define GLASS_SPHERE_ROUGHNESS 1e-3

#define FULL_BLOCKS              587

#define SPHERE_0                 553
#define SPHERE_1                 741
#define NETHER_PORTAL_AXIS_X     629
#define NETHER_PORTAL_AXIS_Z     630
#define BLACK_STAINED_GLASS      942
#define BLUE_STAINED_GLASS       943
#define BROWN_STAINED_GLASS      944
#define CYAN_STAINED_GLASS       945
#define GLASS                    946
#define GLOWSTONE                947
#define GRAY_STAINED_GLASS       948
#define GREEN_STAINED_GLASS      949
#define ICE                      950
#define JACK_O_LANTERN_EAST      951
#define JACK_O_LANTERN_NORTH     952
#define JACK_O_LANTERN_SOUTH     953
#define JACK_O_LANTERN_WEST      954
#define LANTERN_HANGING_FALSE    955
#define LANTERN_HANGING_TRUE     956
#define LAVA                     957
#define LIGHT_BLUE_STAINED_GLASS 958
#define LIGHT_GRAY_STAINED_GLASS 959
#define LIME_STAINED_GLASS       960
#define MAGENTA_STAINED_GLASS    961
#define MAGMA_BLOCK              962
#define OCHRE_FROGLIGHT_X        963
#define OCHRE_FROGLIGHT_Y        964
#define OCHRE_FROGLIGHT_Z        965
#define ORANGE_STAINED_GLASS     966
#define PEARLESCENT_FROGLIGHT_X  967
#define PEARLESCENT_FROGLIGHT_Y  968
#define PEARLESCENT_FROGLIGHT_Z  969
#define PINK_STAINED_GLASS       970
#define PURPLE_STAINED_GLASS     971
#define RED_STAINED_GLASS        972
#define SEA_LANTERN              973
#define SHROOMLIGHT              974
#define TINTED_GLASS             975
#define TORCH                    976
#define VERDANT_FROGLIGHT_X      977
#define VERDANT_FROGLIGHT_Y      978
#define VERDANT_FROGLIGHT_Z      979
#define WALL_TORCH_EAST          980
#define WALL_TORCH_NORTH         981
#define WALL_TORCH_SOUTH         982
#define WALL_TORCH_WEST          983
#define WATER                    984
#define WHITE_STAINED_GLASS      985
#define YELLOW_STAINED_GLASS     986

#define WHITE_WORLD 0 // [0 1]

#define MATERIAL_AO 1 // [0 1]

#define HARDCODED_EMISSIVES             0 // [0 1]
#define EMISSIVE_INTENSITY_MULTIPLIER 1.0 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]

#if RENDER_MODE == 1
	const int EMISSIVE_INTENSITY = 400000;
#else
	const int EMISSIVE_INTENSITY = 2000;
#endif

#define RAIN_PUDDLES         1 // [0 1]
#define RAIN_PUDDLES_SIZE 0.35 // [0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95]

#define RAIN_DIRECTION vec2(0.35, 0.1)

// POM

#define POM           0 // [0 1 2]
#define POM_LAYERS   32 // [32 64 128 256 512]
#define POM_DEPTH   0.5 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
#define POM_DISTANCE 32 // [16 32 48 64 80 96 112 128 144 160 176 192 208 224 240 256 512]

#define POM_SHADOWING   1 // [0 1]
#define POM_DEPTH_WRITE 0 // [0 1]

// WATER

#define WATER_OCTAVES    16 // [2 4 6 8 16 32 48]
#define WAVE_AMPLITUDE 0.80 // [0.00 0.10 0.20 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00 1.10 1.20 1.30 1.40 1.50 1.60 1.70 1.80 1.90 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00 3.10 3.20 3.30 3.40 3.50 3.60 3.70 3.80 3.90 4.00 4.10 4.20 4.30 4.40 4.50 4.60 4.70 4.80 4.90 5.00]
#define WAVE_STEEPNESS 0.60 // [0.00 0.10 0.20 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00 1.10 1.20 1.30 1.40 1.50 1.60 1.70 1.80 1.90 2.00 2.10 2.20 2.30 2.40 2.50 2.60 2.70 2.80 2.90 3.00 3.10 3.20 3.30 3.40 3.50 3.60 3.70 3.80 3.90 4.00 4.10 4.20 4.30 4.40 4.50 4.60 4.70 4.80 4.90 5.00]
#define WAVE_LENGTH       9 // [0 0.5 1 1.5 2 2.5 3 3.5 4 4.5 5 5.5 6 6.5 7 7.5 8 8.5 9 9.5 10]

#define WATER_ABSORPTION_R 30 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_ABSORPTION_G 10 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_ABSORPTION_B 4  // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define WATER_SCATTERING_R 3 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_SCATTERING_G 5 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define WATER_SCATTERING_B 6 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

//////////////////////////////////////////////////////////
/*-------------------- ATMOSPHERICS --------------------*/
//////////////////////////////////////////////////////////

const float sunPathRotation = -40.0; // [-85.0 -80.0 -75.0 -70.0 -65.0 -60.0 -55.0 -50.0 -45.0 -40.0 -35.0 -30.0 -25.0 -20.0 -15.0 -10.0 -5.0 0.0 5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0 85.0]

#define LATITUDE  50.8476
#define LONGITUDE 4.3572

#define CELESTIAL_SIZE_MULTIPLIER 1 // [1 2 3 4]

// ATMOSPHERE

#define ATMOSPHERE_SCALE              25 // [10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define ATMOSPHERE_SCATTERING_STEPS   16 // [8 12 16 20 24 28 32]
#define ATMOSPHERE_TRANSMITTANCE_STEPS 8 // [8 12 16 20 24 28 32]

// CLOUDS

#define CLOUDS_SCALE 50 // [25 30 40 50 60 70 75 80 90 100]

#define CLOUDS_WIND_SPEED 5 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50]

// CLOUDS LAYER 0

#define CLOUDS_LAYER0_ENABLED 1 // [0 1]

#define CLOUDS_LAYER0_SCALE       45 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define CLOUDS_LAYER0_DETAILSCALE 50 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define CLOUDS_LAYER0_SCATTERING_STEPS 20 // [4 8 12 16 20 24 28 32]
#define CLOUDS_LAYER0_OCTAVES           1 // [1 2 3 4 5 6]

#define CLOUDS_LAYER0_FREQUENCY 0.6 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8.0]
#define CLOUDS_LAYER0_DENSITY   100 // [0 10 20 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200]

#define CLOUDS_LAYER0_ALTITUDE  2000 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000 2500 3000 3500 4000 4500 5000 5500 6000 6500 7000 7500 8000 9500 10000]
#define CLOUDS_LAYER0_THICKNESS 1000 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000]
#define CLOUDS_LAYER0_COVERAGE    30 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define CLOUDS_LAYER0_SWIRL       10 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]

// CLOUDS LAYER 1

#define CLOUDS_LAYER1_ENABLED 1 // [0 1]

#define CLOUDS_LAYER1_SCALE      15 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]
#define CLOUDS_LAYER1_DETAILSCALE 1 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 67 68 69 70 71 72 73 74 75 76 77 78 79 80 81 82 83 84 85 86 87 88 89 90 91 92 93 94 95 96 97 98 99 100]

#define CLOUDS_LAYER1_SCATTERING_STEPS 8 // [4 8 12 16 20 24 28 32]
#define CLOUDS_LAYER1_OCTAVES          1 // [1 2 3 4 5 6]

#define CLOUDS_LAYER1_FREQUENCY 1.2 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0 2.1 2.2 2.3 2.4 2.5 2.6 2.7 2.8 2.9 3.0 3.1 3.2 3.3 3.4 3.5 3.6 3.7 3.8 3.9 4.0 4.1 4.2 4.3 4.4 4.5 4.6 4.7 4.8 4.9 5.0 5.1 5.2 5.3 5.4 5.5 5.6 5.7 5.8 5.9 6.0 6.1 6.2 6.3 6.4 6.5 6.6 6.7 6.8 6.9 7.0 7.1 7.2 7.3 7.4 7.5 7.6 7.7 7.8 7.9 8.0]
#define CLOUDS_LAYER1_DENSITY   100 // [0 10 20 30 40 50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200]

#define CLOUDS_LAYER1_ALTITUDE 4000 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000 2500 3000 3500 4000 4500 5000 5500 6000 6500 7000 7500 8000 9500 10000]
#define CLOUDS_LAYER1_THICKNESS 100 // [100 200 300 400 500 600 700 800 900 1000 1100 1200 1300 1400 1500 1600 1700 1800 1900 2000]
#define CLOUDS_LAYER1_COVERAGE   60 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define CLOUDS_LAYER1_SWIRL      90 // [5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]

// STARS

#define STARS_SCALE      280 // [50 60 70 80 90 100 110 120 130 140 150 160 170 180 190 200 210 220 230 240 250 260 270 280 290 300 310 320 330 340 350 360 370 380 390 400]
#define STARS_AMOUNT      50 // [0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define STARS_LUMINANCE   50 // [0 5 10 15 20 25 30 35 40 45 50 55 60 65 70 75 80 85 90 95 100]
#define STARS_MIN_TEMP  2500
#define STARS_MAX_TEMP 50000

//////////////////////////////////////////////////////////
/*------------------ CAMERA SETTINGS -------------------*/
//////////////////////////////////////////////////////////

#define MANUAL_CAMERA 0 // [0 1]
#define PURKINJE      1 // [0 1]

#define APERTURE_BLADES 8 // [3 4 5 6 7 8]
#define FOCAL          24 // [1 2 5 10 14 20 24 28 35 50 70 80 85 100 135 200 300 400 500 600]
#define F_STOPS      16.0 // [1.0 1.2 1.4 2.0 2.8 4.0 5.6 8.0 11.0 16.0 22.0 32.0]
#define ISO           100 // [50 100 200 400 800 1600 3200 6400 12800 25600 51200]
#define SHUTTER_SPEED 125 // [4 5 6 8 10 15 20 30 40 50 60 80 100 125 160 200 250 320 400 500 640 800 1000 1250 1600 2000 2500 3200 4000]

const vec2  sensorSize        = vec2(0.10); // Sensor size for a APS-C sensor in decimeters
const float calibration       = 12.5;       // Light meter calibration
const float sensorSensitivity = 100.0;      // Sensor sensitivity

#define EXPOSURE 2 // [0 1 2]

#define EXPOSURE_GROWTH 2.00
#define EXPOSURE_DECAY  0.20

#if MANUAL_CAMERA == 0 && EXPOSURE == 2
	#define HISTOGRAM_BINS 128

	// Logarithmic scale
	const float minLuminance      = -6.0;
	const float maxLuminance      =  9.0;
	const float luminanceRange    = maxLuminance - minLuminance;
	const float rcpLuminanceRange = 1.0 / luminanceRange;
#endif

//////////////////////////////////////////////////////////
/*------------------- POST-PROCESSING ------------------*/
//////////////////////////////////////////////////////////

#define EIGHT_BITS_FILTER 0 // [0 1]

#define PALETTE 0 // [0 1 2 3 4 5 6 7 8 9 10]

#define BLOOM             1 // [0 1]
#define BLOOM_STRENGTH 0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

#define VIGNETTE             0 // [0 1]
#define VIGNETTE_STRENGTH 0.25 // [0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50]

#define FILM_GRAIN             0 // [0 1]
#define FILM_GRAIN_STRENGTH 1.00 // [0.00 0.10 0.20 0.30 0.40 0.50 0.60 0.70 0.80 0.90 1.00 1.10 1.20 1.30 1.40 1.50 1.60 1.70 1.80 1.90 2.00]

#define SHARPEN             1 // [0 1]
#define SHARPEN_STRENGTH 1.00 // [0.00 0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00]

#define UNDERWATER_DISTORTION         1
#define WATER_DISTORTION_SPEED     0.65
#define WATER_DISTORTION_AMPLITUDE 0.40

#define CEL_SHADING 0 // [0 1]
#define CEL_SHADES  8 // [4 8 12 16 20 24 28 32]

//////////////////////////////////////////////////////////
/*-------------------- ANTI-ALIASING -------------------*/
//////////////////////////////////////////////////////////

#define TAA             1 // [0 1]
#define TAA_STRENGTH 0.95 // [0.10 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.20 0.21 0.22 0.23 0.24 0.25 0.26 0.27 0.28 0.29 0.30 0.31 0.32 0.33 0.34 0.35 0.36 0.37 0.38 0.39 0.40 0.41 0.42 0.43 0.44 0.45 0.46 0.47 0.48 0.49 0.50 0.51 0.52 0.53 0.54 0.55 0.56 0.57 0.58 0.59 0.60 0.61 0.62 0.63 0.64 0.65 0.66 0.67 0.68 0.69 0.70 0.71 0.72 0.73 0.74 0.75 0.76 0.77 0.78 0.79 0.80 0.81 0.82 0.83 0.84 0.85 0.86 0.87 0.88 0.89 0.90 0.91 0.92 0.93 0.94 0.95 0.96 0.97 0.98 0.99]

//////////////////////////////////////////////////////////
/*------------------- COLOR GRADING --------------------*/
//////////////////////////////////////////////////////////

#define ACES 2

#define TONEMAP 	   2 // [-1 0 1 2 3 4 5 6 7]
#define RESPONSE_CURVE 1 // [0 1 2 3 4 5]

#define LUT 0 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]

#define AGX_LOOK 2

#define WHITE_POINT   6500
#define WHITE_BALANCE 6500 // [5000 5100 5200 5300 5400 5500 5600 5700 5800 5900 6000 6100 6200 6300 6400 6500 6600 6700 6800 6900 7000 7100 7200 7300 7400 7500 7600 7700 7800 7900 8000 8100 8200 8300 8400 8500 8600 8700 8800 8900 9000 9100 9200 9300 9400 9500 9600 9700 9800 9900 10000]

#define VIBRANCE   0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define SATURATION 0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define CONTRAST   0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define GAMMA      0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define GAIN       0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define LIFT       0.00 // [-1.00 -0.95 -0.90 -0.85 -0.80 -0.75 -0.70 -0.65 -0.60 -0.55 -0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]

//////////////////////////////////////////////////////////
/*----------------------- DEBUG ------------------------*/
//////////////////////////////////////////////////////////

#define DEBUG_ALBEDO       0 // [0 1]
#define DEBUG_NORMALS      0 // [0 1]
#define DEBUG_HIT_POSITION 0 // [0 1]
#define DEBUG_HISTOGRAM    0 // [0 1]
#define DEBUG_LUT          0 // [0 1]

#define IS_SPECTRAL (RENDER_MODE == 1 && DEBUG_ALBEDO == 0 && DEBUG_NORMALS == 0 && DEBUG_HIT_POSITION == 0)
#define IS_RGB      (RENDER_MODE == 0 || DEBUG_ALBEDO == 1 || DEBUG_NORMALS == 1 || DEBUG_HIT_POSITION == 1)
