/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.api.cookingforblockheads.capability;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.api.util.StackListEntry;
import dev.smolinacadena.refinedcooking.network.KitchenStationNetworkNode;
import dev.smolinacadena.refinedcooking.tile.KitchenStationTile;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IngredientPredicate;
import net.minecraft.item.ItemStack;

public class KitchenItemProvider
implements IKitchenItemProvider {
    private final KitchenStationTile tile;
    private final HashMap<String, Integer> usedStackSizes;

    public KitchenItemProvider(KitchenStationTile tile) {
        this.tile = tile;
        this.usedStackSizes = new HashMap();
    }

    public INetwork getNetwork() {
        return ((KitchenStationNetworkNode)this.tile.getNode()).getNetwork();
    }

    public void resetSimulation() {
        this.usedStackSizes.replaceAll((n, v) -> 0);
    }

    public int getSimulatedUseCount(int slot) {
        return 0;
    }

    public int getSimulatedUseCount(String key) {
        return this.usedStackSizes.getOrDefault(key, 0);
    }

    public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        return ItemStack.field_190927_a;
    }

    public void useItemStack(ItemStack itemStack, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        String itemRegistryName = itemStack.func_77973_b().getRegistryName().toString();
        if (itemStack.func_190916_E() - (simulate ? this.usedStackSizes.getOrDefault(itemRegistryName, 0) : 0) >= amount) {
            ItemStack result = this.getNetwork().extractItem(itemStack, amount, simulate ? Action.SIMULATE : Action.PERFORM);
            if (simulate && !result.func_190926_b()) {
                this.usedStackSizes.put(itemRegistryName, this.usedStackSizes.getOrDefault(itemRegistryName, 0) + result.func_190916_E());
            }
        }
    }

    public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
        return this.getNetwork().insertItem(itemStack, itemStack.func_190916_E(), Action.PERFORM);
    }

    public int getSlots() {
        return this.getNetwork() != null ? this.getNetwork().getItemStorageCache().getList().size() : 0;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public ItemStack returnItemStack(ItemStack itemStack) {
        return itemStack;
    }

    @Nullable
    public SourceItem findSource(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        if (this.getNetwork() != null) {
            List itemStackList = this.getNetwork().getItemStorageCache().getList().getStacks().stream().map(StackListEntry::getStack).collect(Collectors.toList());
            for (ItemStack itemStack : itemStackList) {
                String registryName = itemStack.func_77973_b().getRegistryName().toString();
                if (itemStack.func_190926_b() || !predicate.test(itemStack, itemStack.func_190916_E() - this.getSimulatedUseCount(registryName))) continue;
                return new SourceItem((IKitchenItemProvider)this, 0, itemStack.func_77946_l());
            }
        }
        return null;
    }

    @Nullable
    public SourceItem findSourceAndMarkAsUsed(IngredientPredicate predicate, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket, boolean simulate) {
        SourceItem sourceItem = this.findSource(predicate, maxAmount, inventories, requireBucket, simulate);
        if (sourceItem != null) {
            this.useItemStack(sourceItem.getSourceStack(), Math.min(sourceItem.getSourceStack().func_190916_E(), maxAmount), simulate, inventories, requireBucket);
        }
        return sourceItem;
    }

    public void consumeSourceItem(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireContainer) {
        if (sourceItem.getSourceSlot() < 0) {
            return;
        }
        this.useItemStack(sourceItem.getSourceStack(), maxAmount, false, inventories, requireContainer);
    }

    public void markAsUsed(SourceItem sourceItem, int maxAmount, List<IKitchenItemProvider> inventories, boolean requireBucket) {
        this.useItemStack(sourceItem.getSourceStack(), Math.min(sourceItem.getSourceStack().func_190916_E(), maxAmount), true, inventories, requireBucket);
    }
}

