/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.network;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.network.node.ConnectivityStateChangeCause;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.validator.ItemValidator;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.util.StackUtils;
import dev.smolinacadena.refinedcooking.RefinedCooking;
import dev.smolinacadena.refinedcooking.RefinedCookingItems;
import dev.smolinacadena.refinedcooking.item.KitchenNetworkCardItem;
import dev.smolinacadena.refinedcooking.tile.KitchenAccessPointTile;
import dev.smolinacadena.refinedcooking.tile.KitchenStationTile;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;

public class KitchenAccessPointNetworkNode
extends NetworkNode {
    public static final ResourceLocation ID = new ResourceLocation("refinedcooking", "kitchen_access_point");
    private final BaseItemHandler networkCard = new BaseItemHandler(1).addValidator((Predicate)new ItemValidator((Item)RefinedCookingItems.KITCHEN_NETWORK_CARD.get())).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this)).addListener((handler, slot, reading) -> {
        ItemStack card = handler.getStackInSlot(slot);
        if (card.func_190926_b()) {
            TileEntity tile;
            this.receiver = null;
            this.receiverDimension = null;
            if (!reading && (tile = this.world.func_175625_s(this.pos)) instanceof KitchenAccessPointTile) {
                ((KitchenAccessPointTile)tile).setConnectedToStation(false);
            }
        } else {
            TileEntity tile;
            this.receiver = KitchenNetworkCardItem.getReceiver(card);
            this.receiverDimension = KitchenNetworkCardItem.getDimension(card);
            if (!reading && (tile = this.world.func_175625_s(this.pos)) instanceof KitchenAccessPointTile) {
                ((KitchenAccessPointTile)tile).setConnectedToStation(true);
            }
        }
        if (this.network != null) {
            this.network.getNodeGraph().invalidate(Action.PERFORM, this.network.getWorld(), this.network.getPosition());
        }
    });
    private BlockPos receiver;
    private RegistryKey<World> receiverDimension;

    public KitchenAccessPointNetworkNode(World world, BlockPos pos) {
        super(world, pos);
    }

    public void onConnected(INetwork network) {
        this.onConnectedStateChange(network, true, ConnectivityStateChangeCause.GRAPH_CHANGE);
        TileEntity tile = this.world.func_175625_s(this.pos);
        if (tile instanceof KitchenAccessPointTile) {
            ((KitchenAccessPointTile)tile).setConnectedToStation(!this.networkCard.isEmpty());
        }
        this.network = network;
    }

    public void onDisconnected(INetwork network) {
        super.onDisconnected(network);
        TileEntity tile = this.world.func_175625_s(this.pos);
        if (tile instanceof KitchenAccessPointTile) {
            ((KitchenAccessPointTile)tile).setConnectedToStation(false);
        }
    }

    public CompoundNBT write(CompoundNBT tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.networkCard, (int)0, (CompoundNBT)tag);
        return tag;
    }

    public void read(CompoundNBT tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.networkCard, (int)0, (CompoundNBT)tag);
    }

    public ResourceLocation getId() {
        return ID;
    }

    public int getEnergyUsage() {
        return RefinedCooking.SERVER_CONFIG.getKitchenAccessPoint().getUsage();
    }

    public BaseItemHandler getNetworkCard() {
        return this.networkCard;
    }

    public IItemHandler getDrops() {
        return this.getNetworkCard();
    }

    @Nullable
    public RegistryKey<World> getReceiverDimension() {
        return this.receiverDimension;
    }

    public int getDistance() {
        if (this.receiver == null || this.receiverDimension == null || !this.isSameDimension()) {
            return -1;
        }
        return (int)Math.sqrt(Math.pow(this.pos.func_177958_n() - this.receiver.func_177958_n(), 2.0) + Math.pow(this.pos.func_177956_o() - this.receiver.func_177956_o(), 2.0) + Math.pow(this.pos.func_177952_p() - this.receiver.func_177952_p(), 2.0));
    }

    public boolean isSameDimension() {
        return this.world.func_234923_W_() == this.receiverDimension;
    }

    private boolean canTransmit() {
        return this.canUpdate() && this.receiver != null && this.receiverDimension != null;
    }

    public boolean shouldRebuildGraphOnChange() {
        return true;
    }

    public void visit(INetworkNodeVisitor.Operator operator) {
        super.visit(operator);
        if (this.canTransmit()) {
            if (!this.isSameDimension()) {
                ServerWorld dimensionWorld = this.world.func_73046_m().func_71218_a(this.receiverDimension);
                if (dimensionWorld != null && dimensionWorld.func_175625_s(this.receiver) instanceof KitchenStationTile) {
                    operator.apply((World)dimensionWorld, this.receiver, null);
                }
            } else if (this.world.func_175625_s(this.receiver) instanceof KitchenStationTile) {
                operator.apply(this.world, this.receiver, null);
            }
        }
    }
}

