/*
 * Decompiled with CFR 0.152.
 */
package dev.smolinacadena.refinedcooking.setup;

import dev.smolinacadena.refinedcooking.RefinedCookingBlocks;
import dev.smolinacadena.refinedcooking.RefinedCookingContainers;
import dev.smolinacadena.refinedcooking.block.KitchenAccessPointBlock;
import dev.smolinacadena.refinedcooking.block.KitchenStationBlock;
import dev.smolinacadena.refinedcooking.screen.KitchenAccessPointScreen;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.client.CachedDynamicModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ClientSetup {
    public ClientSetup() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModelBake);
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(RefinedCookingContainers.KITCHEN_ACCESS_POINT, KitchenAccessPointScreen::new);
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        ResourceLocation kitchenStation = new ResourceLocation("refinedcooking", "block/kitchen_station");
        ResourceLocation kitchenStationConnected = new ResourceLocation("refinedcooking", "block/kitchen_station_connected");
        ClientSetup.overrideWithDynamicModel(e, (Block)RefinedCookingBlocks.KITCHEN_STATION.get(), "block/kitchen_station", it -> (Boolean)it.func_177229_b((Property)KitchenStationBlock.CONNECTED) != false ? kitchenStationConnected : kitchenStation, null);
        ResourceLocation kitchenAccessPoint = new ResourceLocation("refinedcooking", "block/kitchen_access_point");
        ResourceLocation kitchenAccessPointConnected = new ResourceLocation("refinedcooking", "block/kitchen_access_point_connected");
        ClientSetup.overrideWithDynamicModel(e, (Block)RefinedCookingBlocks.KITCHEN_ACCESS_POINT.get(), "block/kitchen_access_point", it -> (Boolean)it.func_177229_b((Property)KitchenAccessPointBlock.CONNECTED_TO_STATION) != false ? kitchenAccessPointConnected : kitchenAccessPoint, null);
    }

    private static void overrideWithDynamicModel(ModelBakeEvent event, Block block, String modelPath, @Nullable Function<BlockState, ResourceLocation> modelFunction, @Nullable Function<BlockState, Map<String, String>> textureMapFunction) {
        ResourceLocation modelLocation = new ResourceLocation("refinedcooking", modelPath);
        if (modelFunction == null) {
            modelFunction = it -> modelLocation;
        }
        CachedDynamicModel dynamicModel = new CachedDynamicModel((ModelBakery)event.getModelLoader(), modelFunction, null, textureMapFunction, modelLocation);
        ClientSetup.overrideModelIgnoreState(block, (IBakedModel)dynamicModel, event);
    }

    private static void overrideModelIgnoreState(Block block, IBakedModel model, ModelBakeEvent event) {
        block.func_176194_O().func_177619_a().forEach(state -> {
            ModelResourceLocation modelLocation = BlockModelShapes.func_209554_c((BlockState)state);
            event.getModelRegistry().put(modelLocation, model);
        });
    }
}

