/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_4239;
import net.minecraft.class_7367;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class AutoMetadataPathPackResources
extends class_3255 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String name;
    private final Path path;
    private final class_3264 packType;

    public AutoMetadataPathPackResources(String s, String prefix, Path path, class_3264 packType) {
        super(s, false);
        this.name = prefix + packType.method_14413();
        this.path = path;
        this.packType = packType;
    }

    public @Nullable class_7367<InputStream> method_14410(String ... elements) {
        return null;
    }

    public @Nullable class_7367<InputStream> method_14405(class_3264 packType, class_2960 location) {
        Path path = this.path.resolve(this.name).resolve(location.method_12836());
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        return class_3259.method_45180((class_2960)location, (Path)path);
    }

    public void method_14408(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput) {
        class_4239.method_46346((String)path).get().ifLeft(list -> {
            Path namespacePath = this.path.resolve(this.name).resolve(namespace);
            if (!Files.isDirectory(namespacePath, new LinkOption[0])) {
                return;
            }
            class_3259.method_45183((String)namespace, (Path)namespacePath, (List)list, (class_3262.class_7664)resourceOutput);
        }).ifRight(partialResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)partialResult.message()));
    }

    public @NonNull Set<String> method_14406(class_3264 type) {
        HashSet<String> set = new HashSet<String>();
        Path path = this.path.resolve(this.name);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return Set.of();
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
            for (Path namespacePath : paths) {
                String namespace;
                if (!Files.isDirectory(namespacePath, new LinkOption[0]) || !(namespace = namespacePath.getFileName().toString()).equals(namespace.toLowerCase(Locale.ROOT))) continue;
                set.add(namespace);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to list path {}", (Object)path, (Object)e);
        }
        return set;
    }

    public <T> @Nullable T method_14407(class_3270<T> serializer) {
        if (serializer.method_14420().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)class_155.method_16673().method_48017(this.packType));
            object.addProperty("description", "Global resources");
            return (T)serializer.method_14421(object);
        }
        return null;
    }

    public void close() {
    }
}

