/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.api.data;

import com.mojang.datafixers.util.Either;
import dev.lukebemish.excavatedvariants.api.data.Ore;
import dev.lukebemish.excavatedvariants.impl.data.BaseOre;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

public class OreBuilder {
    private String id;
    private final List<String> oreName = new ArrayList<String>();
    private final List<String> stones = new ArrayList<String>();
    private final List<ResourceLocation> blockIds = new ArrayList<ResourceLocation>();
    private final Map<String, String> translations = new HashMap<String, String>();
    private final List<String> types = new ArrayList<String>();

    @ApiStatus.Internal
    public Ore build() {
        if (this.id == null) {
            throw new IllegalStateException("Ore ID must be set");
        }
        if (this.oreName.isEmpty()) {
            this.oreName.add(this.id);
        }
        return new Ore(new BaseOre(this.id, Optional.of(Either.right(this.oreName)), this.stones, this.blockIds, Optional.empty(), this.types, this.translations));
    }

    public OreBuilder id(String id) {
        if (this.id != null) {
            throw new IllegalStateException("Ore ID already set");
        }
        this.id = id;
        return this;
    }

    public OreBuilder oreNames(String ... oreName) {
        this.oreName.addAll(Arrays.asList(oreName));
        return this;
    }

    public OreBuilder oreNames(List<String> oreName) {
        this.oreName.addAll(oreName);
        return this;
    }

    public OreBuilder stones(String ... stones) {
        this.stones.addAll(Arrays.asList(stones));
        return this;
    }

    public OreBuilder stones(List<String> stones) {
        this.stones.addAll(stones);
        return this;
    }

    public OreBuilder blockIds(ResourceLocation ... blockIds) {
        this.blockIds.addAll(Arrays.asList(blockIds));
        return this;
    }

    public OreBuilder blockIds(List<ResourceLocation> blockIds) {
        this.blockIds.addAll(blockIds);
        return this;
    }

    public OreBuilder translations(Map<String, String> translations) {
        this.translations.putAll(translations);
        return this;
    }

    public OreBuilder types(String ... types) {
        this.types.addAll(Arrays.asList(types));
        return this;
    }

    public OreBuilder types(List<String> types) {
        this.types.addAll(types);
        return this;
    }
}

