/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl;

import blue.endless.jankson.Jankson;
import com.google.common.base.Functions;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.DataResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.excavatedvariants.api.DataProvider;
import dev.lukebemish.excavatedvariants.api.DataReceiver;
import dev.lukebemish.excavatedvariants.api.IOreListModifier;
import dev.lukebemish.excavatedvariants.api.data.Ore;
import dev.lukebemish.excavatedvariants.api.data.Stone;
import dev.lukebemish.excavatedvariants.impl.ExcavatedVariantsClient;
import dev.lukebemish.excavatedvariants.impl.MiningLevelTagHolder;
import dev.lukebemish.excavatedvariants.impl.ModifiedOreBlock;
import dev.lukebemish.excavatedvariants.impl.client.ClientServices;
import dev.lukebemish.excavatedvariants.impl.data.BaseOre;
import dev.lukebemish.excavatedvariants.impl.data.BaseStone;
import dev.lukebemish.excavatedvariants.impl.data.MappingsCache;
import dev.lukebemish.excavatedvariants.impl.data.ModConfig;
import dev.lukebemish.excavatedvariants.impl.data.ModData;
import dev.lukebemish.excavatedvariants.impl.data.filter.Filter;
import dev.lukebemish.excavatedvariants.impl.platform.Services;
import dev.lukebemish.excavatedvariants.impl.recipe.OreConversionRecipe;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ExcavatedVariants {
    public static final int DEFAULT_COMPAT_PRIORITY = -10;
    public static final Jankson JANKSON = Jankson.builder().build();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    public static final Gson GSON_CONDENSED = new GsonBuilder().setLenient().create();
    public static final String MOD_ID = "excavated_variants";
    public static final Supplier<RecipeSerializer<OreConversionRecipe>> ORE_CONVERSION = Services.MAIN_PLATFORM_TARGET.get().registerRecipeSerializer("ore_conversion", () -> new SimpleCraftingRecipeSerializer(OreConversionRecipe::new));
    public static final Logger LOGGER = LogManager.getLogger((String)"excavated_variants");
    public static final List<RegistryFuture> blockList = new ArrayList<RegistryFuture>();
    public static final Set<ResourceLocation> neededRls = new HashSet<ResourceLocation>();
    private static final List<Supplier<Item>> items = new ArrayList<Supplier<Item>>();
    private static final Map<String, ModifiedOreBlock> blocks = new HashMap<String, ModifiedOreBlock>();
    public static List<Pair<BaseOre, HashSet<BaseStone>>> oreStoneList;
    public static Set<ResourceLocation> loadedBlockRLs;
    private static Set<BaseOre> knownOres;
    private static Set<BaseStone> knownStones;
    private static Map<String, BaseOre> ores;
    private static Map<String, BaseStone> stones;
    private static Set<Pair<BaseOre, BaseStone>> allPairs;
    private static ModConfig configs;
    private static boolean loaded;
    private static MappingsCache mappingsCache;
    public static final DataResourceCache DATA_CACHE;

    private ExcavatedVariants() {
    }

    private static void planTagLang(ResourceLocation rl) {
        if (Services.PLATFORM.isClient()) {
            String path = rl.m_135815_();
            if (path.startsWith("items/")) {
                path = path.replaceFirst("items/", "");
            } else if (path.startsWith("blocks/")) {
                path = path.replaceFirst("blocks/", "");
            }
            ArrayList<String> parts = new ArrayList<String>(Arrays.asList(path.split("/")));
            Collections.reverse(parts);
            String englishName = String.join((CharSequence)" ", parts.stream().flatMap(s -> Arrays.stream(s.split("_"))).map(s -> {
                if (!s.isEmpty()) {
                    return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
                }
                return s;
            }).toList());
            String tagName = "tag." + rl.m_135827_() + "." + String.join((CharSequence)".", Arrays.asList(path.split("/")));
            ExcavatedVariantsClient.planLang(tagName, englishName);
        }
    }

    public static void init() {
        ResourceLocation tagRl;
        ExcavatedVariants.setupMap();
        MiningLevelTagHolder tierHolder = new MiningLevelTagHolder();
        for (Pair<BaseOre, HashSet<BaseStone>> p : oreStoneList) {
            BaseOre ore = (BaseOre)p.getFirst();
            ArrayList<CallSite> ids = new ArrayList<CallSite>();
            for (BaseStone stone : (HashSet)p.getSecond()) {
                String fullId = stone.id + "_" + ore.id;
                blockList.add(new RegistryFuture(fullId, ore, stone));
                neededRls.add(ore.blockId.get(0));
                neededRls.add(stone.blockId);
                if (ExcavatedVariants.getConfig().addConversionRecipes) {
                    OreConversionRecipe.oreMap.put(new ResourceLocation(MOD_ID, fullId), ore.blockId.get(0));
                }
                for (String type : Sets.union(new HashSet<String>(stone.types), new HashSet<String>(ore.types))) {
                    ResourceLocation tagRl2 = new ResourceLocation(MOD_ID, type + "_ores");
                    ResourceLocation id2 = new ResourceLocation(MOD_ID, fullId);
                    ExcavatedVariants.planItemTag(ExcavatedVariants.rlToBlock(tagRl2), id2);
                    ExcavatedVariants.planBlockTag(ExcavatedVariants.rlToItem(tagRl2), id2);
                }
                tierHolder.add(fullId, ore, stone);
                ids.add((CallSite)((Object)fullId));
            }
            for (String orename : ore.oreName) {
                for (String string : ids) {
                    String oreTypeName = orename.substring(0, orename.length() - 4);
                    if (Services.PLATFORM.isQuilt()) {
                        ExcavatedVariants.planItemTag(new ResourceLocation("c", "items/" + orename + "s"), new ResourceLocation(MOD_ID, string), true);
                        ExcavatedVariants.planBlockTag(new ResourceLocation("c", "blocks/" + orename + "s"), new ResourceLocation(MOD_ID, string));
                        ExcavatedVariants.planItemTag(new ResourceLocation("c", "items/ores/" + oreTypeName), new ResourceLocation(MOD_ID, string), true);
                        ExcavatedVariants.planBlockTag(new ResourceLocation("c", "blocks/ores/" + oreTypeName), new ResourceLocation(MOD_ID, string));
                    } else if (orename.endsWith("_ore")) {
                        ExcavatedVariants.planItemTag(new ResourceLocation("forge", "items/ores/" + oreTypeName), new ResourceLocation(MOD_ID, string), true);
                        ExcavatedVariants.planBlockTag(new ResourceLocation("forge", "blocks/ores/" + oreTypeName), new ResourceLocation(MOD_ID, string));
                    }
                    if (!Arrays.asList("iron_ore", "gold_ore", "coal_ore", "emerald_ore", "diamond_ore", "redstone_ore", "quartz_ore", "copper_ore", "lapis_ore", "netherite_scrap_ore").contains(orename)) continue;
                    ExcavatedVariants.planItemTag(new ResourceLocation("minecraft", "items/" + orename + "s"), new ResourceLocation(MOD_ID, string));
                    ExcavatedVariants.planBlockTag(new ResourceLocation("minecraft", "blocks/" + orename + "s"), new ResourceLocation(MOD_ID, string));
                }
            }
        }
        ExcavatedVariants.getConfig().modifiers.forEach(modifier -> {
            List<ResourceLocation> tags;
            if (modifier.tags().isPresent() && !(tags = modifier.tags().get()).isEmpty()) {
                List<ResourceLocation> locations = ExcavatedVariants.getMatching(modifier.filter()).stream().map(p -> new ResourceLocation(MOD_ID, ((BaseStone)p.getSecond()).id + "_" + ((BaseOre)p.getFirst()).id)).toList();
                tags.forEach(tag -> locations.forEach(rl -> {
                    if (tag.m_135815_().startsWith("blocks/")) {
                        ExcavatedVariants.planBlockTag(tag, rl);
                    } else if (tag.m_135815_().startsWith("items/")) {
                        ExcavatedVariants.planItemTag(tag, rl);
                    }
                }));
            }
        });
        for (BaseStone stone : knownStones) {
            for (String type : stone.types) {
                tagRl = new ResourceLocation(MOD_ID, type + "_stones");
                ExcavatedVariants.planItemTag(ExcavatedVariants.rlToItem(tagRl), stone.blockId, true);
                ExcavatedVariants.planBlockTag(ExcavatedVariants.rlToBlock(tagRl), stone.blockId);
            }
        }
        for (BaseOre ore : knownOres) {
            for (String type : ore.types) {
                tagRl = new ResourceLocation(MOD_ID, type + "_ores");
                ore.blockId.forEach(id -> {
                    ExcavatedVariants.planItemTag(ExcavatedVariants.rlToBlock(tagRl), id, true);
                    ExcavatedVariants.planBlockTag(ExcavatedVariants.rlToItem(tagRl), id);
                });
            }
        }
        DATA_CACHE.tags().queue((Supplier)tierHolder);
        Services.MAIN_PLATFORM_TARGET.get().registerFeatures();
        Services.CREATIVE_TAB_LOADER.get().registerCreativeTab();
        loaded = true;
    }

    public static boolean setupMap() {
        if (oreStoneList == null || oreStoneList.size() == 0) {
            Collection<String> modids;
            try {
                modids = Services.PLATFORM.getModIds();
            }
            catch (NullPointerException e) {
                oreStoneList = new ArrayList<Pair<BaseOre, HashSet<BaseStone>>>();
                return false;
            }
            ExcavatedVariants.internalSetupMap(modids);
        }
        return true;
    }

    public static Set<Pair<BaseOre, BaseStone>> getMatching(Filter filter) {
        ExcavatedVariants.setupMap();
        return allPairs.stream().filter(p -> filter.matches((BaseOre)p.getFirst(), (BaseStone)p.getSecond())).collect(Collectors.toSet());
    }

    private static synchronized void internalSetupMap(Collection<String> modids) {
        oreStoneList = new ArrayList<Pair<BaseOre, HashSet<BaseStone>>>();
        knownOres = new HashSet<BaseOre>();
        knownStones = new HashSet<BaseStone>();
        HashMap<String, BaseStone> stoneMap = new HashMap<String, BaseStone>();
        HashMap<String, List<BaseOre>> oreMap = new HashMap<String, List<BaseOre>>();
        for (ModData modData : ExcavatedVariants.getConfig().mods) {
            if (!modids.containsAll(modData.modId)) continue;
            ExcavatedVariants.processData(stoneMap, oreMap, modData.providedStones, modData.providedOres);
        }
        List<DataProvider> providers = Services.COMPAT.getListeners(DataProvider.class);
        for (DataProvider provider : providers) {
            ArrayList<BaseStone> arrayList = new ArrayList<BaseStone>();
            ArrayList<BaseOre> ores = new ArrayList<BaseOre>();
            provider.provideOres(ore -> ores.add(ore.getBase()), stone -> stones.add(stone.getBase()));
            ExcavatedVariants.processData(stoneMap, oreMap, arrayList, ores);
        }
        for (Object id : oreMap.keySet()) {
            List list = (List)oreMap.get(id);
            ArrayList<String> stones = new ArrayList<String>();
            for (BaseOre baseOre : list) {
                stones.addAll(baseOre.stone);
            }
            Pair pair = new Pair((Object)((BaseOre)list.get(0)).clone(), new HashSet());
            if (list.size() > 1) {
                ((BaseOre)pair.getFirst()).blockId = new ArrayList<ResourceLocation>();
                ((BaseOre)pair.getFirst()).oreName = new ArrayList<String>();
                ((BaseOre)pair.getFirst()).stone = new ArrayList<String>();
                ((BaseOre)pair.getFirst()).types = new ArrayList<String>();
                for (BaseOre baseOre : list) {
                    ((BaseOre)pair.getFirst()).blockId.addAll(baseOre.blockId);
                    ((BaseOre)pair.getFirst()).oreName.addAll(baseOre.oreName);
                    ((BaseOre)pair.getFirst()).stone.addAll(baseOre.stone);
                    ((BaseOre)pair.getFirst()).types.addAll(baseOre.types);
                }
                List list2 = new HashSet<String>(((BaseOre)pair.getFirst()).types).stream().toList();
                ((BaseOre)pair.getFirst()).types.clear();
                ((BaseOre)pair.getFirst()).types.addAll(list2);
                List oreNames = new HashSet<String>(((BaseOre)pair.getFirst()).oreName).stream().toList();
                ((BaseOre)pair.getFirst()).oreName.clear();
                ((BaseOre)pair.getFirst()).oreName.addAll(oreNames);
            }
            oreStoneList.add((Pair<BaseOre, HashSet<BaseStone>>)pair);
            for (BaseStone stone2 : stoneMap.values()) {
                if (stones.contains(stone2.id)) continue;
                if (!((BaseOre)pair.getFirst()).types.stream().anyMatch(stone2.types::contains) || ExcavatedVariants.getConfig().configResource.getBlacklist().matches((BaseOre)pair.getFirst(), stone2)) continue;
                ((HashSet)pair.getSecond()).add(stone2);
            }
        }
        ExcavatedVariants.deprecatedApiStandIn();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Pair pair : oreStoneList) {
            arrayList.add(new Pair((Object)new Ore((BaseOre)pair.getFirst()), ((HashSet)pair.getSecond()).stream().map(Stone::new).collect(Collectors.toSet())));
        }
        List apiList = Collections.unmodifiableList(arrayList);
        Services.COMPAT.getListeners(DataReceiver.class).forEach(r -> r.receiveData(apiList));
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<Pair<BaseOre, HashSet<BaseStone>>> out = new ArrayList<Pair<BaseOre, HashSet<BaseStone>>>();
        for (Pair pair : oreStoneList) {
            BaseOre ore3 = (BaseOre)pair.getFirst();
            if (hashSet.contains(ore3.id)) continue;
            hashSet.add(ore3.id);
            Pair o2 = new Pair((Object)ore3, new HashSet());
            out.add(o2);
            knownOres.add((BaseOre)o2.getFirst());
            for (BaseStone stone3 : (HashSet)pair.getSecond()) {
                if (ExcavatedVariants.getConfig().configResource.getBlacklist().matches(ore3, stone3)) continue;
                ((HashSet)o2.getSecond()).add(stone3);
            }
        }
        knownStones.addAll(stoneMap.values());
        stones = knownStones.stream().collect(Collectors.toMap(s -> s.id, Functions.identity()));
        ores = knownOres.stream().collect(Collectors.toMap(o -> o.id, Functions.identity()));
        allPairs = out.stream().flatMap(p -> ((HashSet)p.getSecond()).stream().map(o -> new Pair((Object)((BaseOre)p.getFirst()), o))).collect(Collectors.toSet());
        oreStoneList = out;
    }

    private static void deprecatedApiStandIn() {
        for (IOreListModifier listListener : Services.COMPAT.getListeners(IOreListModifier.class)) {
            listListener.modify(new ArrayList<Pair<dev.lukebemish.excavatedvariants.data.BaseOre, HashSet<dev.lukebemish.excavatedvariants.data.BaseStone>>>(), Set.of());
        }
    }

    private static void processData(Map<String, BaseStone> stoneMap, Map<String, List<BaseOre>> oreMap, List<BaseStone> providedStones, List<BaseOre> providedOres) {
        for (BaseStone stone : providedStones) {
            if (!stoneMap.containsKey(stone.id)) {
                stoneMap.put(stone.id, stone);
                continue;
            }
            BaseStone stoneOld = stoneMap.get(stone.id);
            ArrayList<String> types = new ArrayList<String>(stoneOld.types);
            types.addAll(stone.types.stream().filter(s -> !stoneOld.types.contains(s)).toList());
            stoneOld.types = types;
        }
        for (BaseOre ore : providedOres) {
            oreMap.computeIfAbsent(ore.id, k -> new ArrayList());
            oreMap.get(ore.id).add(ore);
        }
    }

    public static Map<String, BaseOre> getOres() {
        return ores;
    }

    public static Map<String, BaseStone> getStones() {
        return stones;
    }

    public static ModConfig getConfig() {
        if (configs == null) {
            configs = ModConfig.load();
        }
        return configs;
    }

    public static Map<String, ModifiedOreBlock> getBlocks() {
        return blocks;
    }

    public static List<RegistryFuture> getBlockList() {
        return blockList;
    }

    public static void registerBlockAndItem(BiConsumer<ResourceLocation, Block> blockRegistrar, BiFunction<ResourceLocation, Supplier<Item>, Supplier<Item>> itemRegistrar, RegistryFuture future) {
        if (!future.done) {
            future.done = true;
            String id = future.full_id;
            BaseOre o = future.ore;
            BaseStone s = future.stone;
            ResourceLocation rlToReg = new ResourceLocation(MOD_ID, future.full_id);
            ModifiedOreBlock.setupStaticWrapper(o, s);
            ModifiedOreBlock b = Services.MAIN_PLATFORM_TARGET.get().makeDefaultOreBlock(o, s);
            blockRegistrar.accept(rlToReg, (Block)b);
            blocks.put(id, b);
            Supplier<Item> i = itemRegistrar.apply(rlToReg, () -> new BlockItem((Block)b, new Item.Properties()));
            items.add(i);
            ClientServices.RENDER_TYPE_HANDLER.setRenderTypeMipped((Block)b);
        }
    }

    public static List<Supplier<Item>> getItems() {
        return items;
    }

    public static boolean hasLoaded() {
        return loaded;
    }

    public static synchronized MappingsCache getMappingsCache() {
        if (mappingsCache == null && ExcavatedVariants.setupMap()) {
            MappingsCache cache = MappingsCache.load();
            knownOres.forEach(ore -> cache.oreMappings.put(ore.id, Set.copyOf(ore.blockId)));
            knownStones.forEach(stone -> cache.stoneMappings.put(stone.id, stone.blockId));
            HashMap<String, Set<ResourceLocation>> newOres = new HashMap<String, Set<ResourceLocation>>();
            HashMap<String, ResourceLocation> newStones = new HashMap<String, ResourceLocation>();
            cache.oreMappings.forEach((key, rls) -> {
                Set set = rls.stream().filter(it -> Services.REGISTRY_UTIL.getBlockById((ResourceLocation)it) != null).collect(Collectors.toUnmodifiableSet());
                if (!set.isEmpty()) {
                    newOres.put((String)key, set);
                }
            });
            cache.stoneMappings.forEach((key, rl) -> {
                if (Services.REGISTRY_UTIL.getBlockById((ResourceLocation)rl) != null) {
                    newStones.put((String)key, (ResourceLocation)rl);
                }
            });
            cache.oreMappings = newOres;
            cache.stoneMappings = newStones;
            cache.save();
            mappingsCache = cache;
        }
        return mappingsCache;
    }

    private static void planBlockTag(ResourceLocation tag, ResourceLocation block, boolean inLang) {
        DATA_CACHE.tags().queue(tag, block);
        if (inLang) {
            ExcavatedVariants.planTagLang(tag);
        }
    }

    private static void planBlockTag(ResourceLocation tag, ResourceLocation block) {
        ExcavatedVariants.planBlockTag(tag, block, false);
    }

    private static void planItemTag(ResourceLocation tag, ResourceLocation item, boolean inLang) {
        DATA_CACHE.tags().queue(tag, item);
        if (inLang) {
            ExcavatedVariants.planTagLang(tag);
        }
    }

    private static void planItemTag(ResourceLocation tag, ResourceLocation item) {
        ExcavatedVariants.planItemTag(tag, item, false);
    }

    private static ResourceLocation rlToBlock(ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), "blocks/" + rl.m_135815_());
    }

    private static ResourceLocation rlToItem(ResourceLocation rl) {
        return new ResourceLocation(rl.m_135827_(), "items/" + rl.m_135815_());
    }

    static {
        loadedBlockRLs = new HashSet<ResourceLocation>();
        loaded = false;
        DATA_CACHE = (DataResourceCache)ResourceCache.register((ResourceCache)new DataResourceCache(new ResourceLocation(MOD_ID, "data")));
    }

    public static class RegistryFuture {
        public final BaseOre ore;
        public final BaseStone stone;
        public final String full_id;
        public boolean done = false;

        public RegistryFuture(String s, BaseOre ore, BaseStone stone) {
            this.full_id = s;
            this.ore = ore;
            this.stone = stone;
        }
    }
}

