/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl;

import com.mojang.datafixers.util.Pair;
import dev.lukebemish.dynamicassetgenerator.api.IPathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.ResourceCache;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.AssetResourceCache;
import dev.lukebemish.excavatedvariants.impl.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.impl.JsonHelper;
import dev.lukebemish.excavatedvariants.impl.LangBuilder;
import dev.lukebemish.excavatedvariants.impl.client.ResourceAssembler;
import dev.lukebemish.excavatedvariants.impl.data.BaseOre;
import dev.lukebemish.excavatedvariants.impl.data.BaseStone;
import dev.lukebemish.excavatedvariants.impl.data.ModData;
import dev.lukebemish.excavatedvariants.impl.platform.Services;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExcavatedVariantsClient {
    public static final LangBuilder LANG_BUILDER = new LangBuilder();
    public static final AssetResourceCache ASSET_CACHE = (AssetResourceCache)ResourceCache.register((ResourceCache)new AssetResourceCache(new ResourceLocation("excavated_variants", "assets")));

    private ExcavatedVariantsClient() {
    }

    public static void init() {
        Collection<String> modids = Services.PLATFORM.getModIds();
        ExcavatedVariants.setupMap();
        HashMap<String, BaseStone> stoneMap = new HashMap<String, BaseStone>();
        for (ModData mod : ExcavatedVariants.getConfig().mods) {
            if (!modids.containsAll(mod.modId)) continue;
            for (BaseStone baseStone : mod.providedStones) {
                stoneMap.put(baseStone.id, baseStone);
            }
        }
        Map<BaseOre, BaseStone> originalPairs = ExcavatedVariants.oreStoneList.stream().flatMap(p -> ((HashSet)p.getSecond()).stream().map(stone -> new Pair((Object)((BaseOre)p.getFirst()), (Object)((BaseStone)stoneMap.get(((BaseOre)p.getFirst()).stone.get(0)))))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> a));
        ArrayList<Pair> toMake = new ArrayList<Pair>();
        for (Pair pair : ExcavatedVariants.oreStoneList) {
            BaseOre ore = (BaseOre)pair.getFirst();
            for (BaseStone stone : (HashSet)pair.getSecond()) {
                String fullId = stone.id + "_" + ore.id;
                toMake.add(new Pair((Object)ore, (Object)stone));
                ASSET_CACHE.planSource(new ResourceLocation("excavated_variants", "models/item/" + fullId + ".json"), (rl, context) -> JsonHelper.getItemModel(fullId));
                LANG_BUILDER.add(fullId, stone, ore);
            }
        }
        ASSET_CACHE.planSource(new IPathAwareInputStreamSource(){

            @NotNull
            public Set<ResourceLocation> getLocations() {
                return LANG_BUILDER.languages().stream().map(s -> new ResourceLocation("excavated_variants_generated", "lang/" + s + ".json")).collect(Collectors.toSet());
            }

            @Nullable
            public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
                return LANG_BUILDER.build(outRl.m_135815_().substring(5, outRl.m_135815_().length() - 5));
            }
        });
        ASSET_CACHE.planSource(() -> {
            ResourceAssembler source = new ResourceAssembler(originalPairs, toMake);
            source.assemble();
            return source;
        });
    }

    static void planLang(String key, String enName) {
        LANG_BUILDER.add(key, enName);
    }
}

