/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.ServerPrePackRepository;
import dev.lukebemish.dynamicassetgenerator.api.templates.TagFile;
import dev.lukebemish.excavatedvariants.impl.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.impl.data.BaseOre;
import dev.lukebemish.excavatedvariants.impl.data.BaseStone;
import dev.lukebemish.excavatedvariants.impl.platform.Services;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;

public class MiningLevelTagHolder
implements Supplier<Map<ResourceLocation, Set<ResourceLocation>>> {
    private final ArrayList<CheckPair> toCheck = new ArrayList();

    public void add(String fullId, BaseOre ore, BaseStone stone) {
        this.toCheck.add(new CheckPair(fullId, ore.blockId.get(0), stone.blockId));
    }

    @Override
    public Map<ResourceLocation, Set<ResourceLocation>> get() {
        HashMap<ResourceLocation, Set<ResourceLocation>> tags = new HashMap<ResourceLocation, Set<ResourceLocation>>();
        List<ResourceLocation> tagNames = Services.PLATFORM.getMiningLevels();
        HashMap blockToLevelMap = new HashMap();
        Map memberMap = tagNames.stream().collect(Collectors.toMap(Function.identity(), this::getTagMembers));
        this.toCheck.forEach(pair -> {
            int maxValue = Math.max(this.getOrCreateLevel(tagNames, memberMap, blockToLevelMap, pair.stoneId), this.getOrCreateLevel(tagNames, memberMap, blockToLevelMap, pair.oreId));
            if (maxValue != -1) {
                tags.computeIfAbsent((ResourceLocation)tagNames.get(maxValue), k -> new HashSet()).add(new ResourceLocation("excavated_variants", pair.fullId));
            }
        });
        return tags;
    }

    private int getOrCreateLevel(List<ResourceLocation> levels, Map<ResourceLocation, List<ResourceLocation>> memberMap, Map<ResourceLocation, Integer> map, ResourceLocation lookup) {
        return map.computeIfAbsent(lookup, key -> {
            for (Map.Entry entry : memberMap.entrySet()) {
                if (!((List)entry.getValue()).contains(key)) continue;
                return levels.indexOf(entry.getKey());
            }
            return -1;
        });
    }

    private List<ResourceLocation> getTagMembers(ResourceLocation location) {
        final String type = location.m_135815_().split("/")[0];
        ArrayList<ResourceLocation> members = new ArrayList<ResourceLocation>();
        ResourceLocation toRead = new ResourceLocation(location.m_135827_(), "tags/" + location.m_135815_() + ".json");
        try (Stream read = ServerPrePackRepository.getResources((ResourceLocation)toRead);){
            read.forEach(is -> {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));){
                    JsonElement parser = JsonParser.parseReader((Reader)reader);
                    try {
                        TagFile file = (TagFile)TagFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)parser).getOrThrow(false, e -> {});
                        if (file.replace()) {
                            members.clear();
                        }
                        file.values().forEach(value -> value.m_215927_((TagEntry.Lookup)new TagEntry.Lookup<ResourceLocation>(){

                            public ResourceLocation element(ResourceLocation elementLocation) {
                                return elementLocation;
                            }

                            public Collection<ResourceLocation> m_214048_(ResourceLocation tagLocation) {
                                return MiningLevelTagHolder.this.getTagMembers(new ResourceLocation(tagLocation.m_135827_(), type + "/" + tagLocation.m_135815_()));
                            }
                        }, members::add));
                    }
                    catch (RuntimeException e2) {
                        ExcavatedVariants.LOGGER.error("Issue parsing tag at '{}':", (Object)toRead, (Object)e2);
                    }
                }
                catch (IOException e3) {
                    ExcavatedVariants.LOGGER.error("Issue reading tag at '{}':", (Object)toRead, (Object)e3);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return members;
    }

    private record CheckPair(String fullId, ResourceLocation oreId, ResourceLocation stoneId) {
    }
}

