/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.excavatedvariants.impl.ModifiedOreBlock;
import dev.lukebemish.excavatedvariants.impl.client.VariantAssembler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class BlockStateData {
    public static final Codec<BlockStateData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)VariantAssembler.CODEC.listOf()).fieldOf("variants").forGetter(BlockStateData::getVariants)).apply((Applicative)instance, BlockStateData::new));
    private final Map<String, List<VariantAssembler>> variants = new HashMap<String, List<VariantAssembler>>();

    public Map<String, List<VariantAssembler>> getVariants() {
        return this.variants;
    }

    public BlockStateData() {
    }

    public BlockStateData(Map<String, List<VariantAssembler>> variants) {
        this.variants.putAll(variants);
    }

    public static BlockStateData create(ModifiedOreBlock block, List<ResourceLocation> modelLocs) {
        BlockStateData assembler = new BlockStateData();
        if (block.isFacingType()) {
            for (Direction d : Direction.values()) {
                ArrayList<VariantAssembler> vars = new ArrayList<VariantAssembler>();
                for (ResourceLocation rl : modelLocs) {
                    vars.add(VariantAssembler.fromFacing(rl, d));
                }
                assembler.variants.put("facing=" + d.m_122433_(), vars);
            }
        } else if (block.isAxisType()) {
            for (Direction.Axis a : Direction.Axis.values()) {
                ArrayList<VariantAssembler> vars = new ArrayList<VariantAssembler>();
                for (ResourceLocation rl : modelLocs) {
                    vars.add(VariantAssembler.fromAxis(rl, a));
                }
                assembler.variants.put("axis=" + a.m_122477_(), vars);
            }
        } else {
            ArrayList<VariantAssembler> vars = new ArrayList<VariantAssembler>();
            for (ResourceLocation rl : modelLocs) {
                vars.add(VariantAssembler.fromModel(rl));
            }
            assembler.variants.put("", vars);
        }
        return assembler;
    }
}

