/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.client;

import dev.lukebemish.excavatedvariants.api.ExcavatedVariantsListener;
import dev.lukebemish.excavatedvariants.api.client.ModelData;
import dev.lukebemish.excavatedvariants.api.client.ResourceProvider;
import dev.lukebemish.excavatedvariants.api.client.TexFaceProvider;
import dev.lukebemish.excavatedvariants.impl.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.impl.client.BackupFetcher;
import dev.lukebemish.excavatedvariants.impl.client.ParsedModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.resources.ResourceLocation;

@ExcavatedVariantsListener
public class DefaultProvider
implements ResourceProvider {
    @Override
    public void provideOreTextures(List<ResourceLocation> ores, BiConsumer<ResourceLocation, List<TexFaceProvider>> textureProducerConsumer) {
        for (ResourceLocation ore : ores) {
            List<ResourceLocation> blockModels = this.getBlockModels(ore);
            if (blockModels == null || blockModels.isEmpty()) {
                ExcavatedVariants.LOGGER.warn("Could not find blockstates for ore " + ore);
                continue;
            }
            ArrayList<TexFaceProvider> models = new ArrayList<TexFaceProvider>();
            for (ResourceLocation model : blockModels) {
                try {
                    models.add(ParsedModel.getFromLocation(model).makeTextureProvider());
                }
                catch (IOException iOException) {}
            }
            if (models.isEmpty()) continue;
            textureProducerConsumer.accept(ore, models);
        }
    }

    @Override
    public void provideStoneTextures(List<ResourceLocation> stones, BiConsumer<ResourceLocation, List<ModelData>> textureConsumer) {
        for (ResourceLocation stone : stones) {
            List<ResourceLocation> blockModels = this.getBlockModels(stone);
            if (blockModels == null || blockModels.isEmpty()) {
                ExcavatedVariants.LOGGER.warn("Could not find blockstates for stone " + stone);
                continue;
            }
            ArrayList<ModelData> models = new ArrayList<ModelData>();
            for (ResourceLocation model : blockModels) {
                try {
                    models.add(ParsedModel.getFromLocation(model).makeStoneModel());
                }
                catch (IOException iOException) {}
            }
            if (models.isEmpty()) continue;
            textureConsumer.accept(stone, models);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ResourceLocation> getBlockModels(ResourceLocation block) {
        BlockModelDefinition.Context ctx = new BlockModelDefinition.Context();
        try (InputStream blockstateStream = BackupFetcher.getBlockStateFile(block);){
            BlockModelDefinition definition = BlockModelDefinition.m_111540_((BlockModelDefinition.Context)ctx, (Reader)new BufferedReader(new InputStreamReader(blockstateStream)));
            if (!definition.m_111543_()) {
                HashSet oreModels = new HashSet();
                Object list2 = definition.m_111539_().entrySet().iterator();
                while (true) {
                    if (!list2.hasNext()) {
                        list2 = List.copyOf(oreModels);
                        return list2;
                    }
                    Map.Entry entry = list2.next();
                    oreModels.addAll(((MultiVariant)entry.getValue()).m_7970_());
                }
            }
            List<ResourceLocation> list = List.of();
            return list;
        }
        catch (IOException e) {
            return List.of();
        }
    }

    @Override
    public int priority() {
        return -10;
    }
}

