/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.client;

import blue.endless.jankson.JsonObject;
import blue.endless.jankson.api.SyntaxError;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.ITexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.AnimationFrameCapture;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.AnimationSplittingSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.ForegroundTransfer;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.Overlay;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.TextureReader;
import dev.lukebemish.excavatedvariants.api.client.Face;
import dev.lukebemish.excavatedvariants.api.client.ModelData;
import dev.lukebemish.excavatedvariants.api.client.TexFaceProvider;
import dev.lukebemish.excavatedvariants.impl.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.impl.client.BackupFetcher;
import dev.lukebemish.excavatedvariants.impl.client.StoneModelData;
import dev.lukebemish.excavatedvariants.impl.codecs.JanksonOps;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ParsedModel(Optional<ResourceLocation> parent, Map<String, String> textures, List<ElementDefinition> elements, Optional<Map<String, ParsedModel>> children) {
    public static final Codec<ParsedModel> CODEC = ExtraCodecs.m_184415_(() -> RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.f_135803_.optionalFieldOf("parent").forGetter(ParsedModel::parent), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("textures", Map.of()).forGetter(ParsedModel::textures), (App)ElementDefinition.CODEC.listOf().optionalFieldOf("elements", List.of()).forGetter(ParsedModel::elements), (App)Codec.unboundedMap((Codec)Codec.STRING, CODEC).optionalFieldOf("children").forGetter(ParsedModel::children)).apply((Applicative)i, ParsedModel::new)));

    @Nullable
    public static ResourceLocation resolveTexture(Map<String, String> map, String texName) {
        String found = map.get(texName = texName.substring(1));
        if (found == null) {
            return null;
        }
        if (found.startsWith("#")) {
            return ParsedModel.resolveTexture(map, found);
        }
        return ResourceLocation.m_135822_((String)found, (char)':');
    }

    public static String resolveTextureSymbol(Map<String, String> map, String texName) {
        String found = map.get(texName = texName.substring(1));
        if (found == null) {
            return texName;
        }
        if (found.startsWith("#")) {
            return ParsedModel.resolveTextureSymbol(map, found);
        }
        return texName;
    }

    @NotNull
    public static ParsedModel getFromLocation(ResourceLocation rl) throws IOException {
        ParsedModel parsedModel;
        block8: {
            InputStream is = BackupFetcher.getModelFile(rl);
            try {
                JsonObject json = ExcavatedVariants.JANKSON.load(is);
                parsedModel = (ParsedModel)CODEC.parse((DynamicOps)JanksonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {});
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SyntaxError | IOException | RuntimeException e2) {
                    throw new IOException("Could not read model " + rl, e2);
                }
            }
            is.close();
        }
        return parsedModel;
    }

    public Map<String, String> getTextureMap() throws IOException {
        ParsedModel parent;
        HashMap<String, String> textures = new HashMap<String, String>();
        ParsedModel parsedModel = parent = this.parent().isEmpty() ? null : ParsedModel.getFromLocation(this.parent().get());
        if (parent != null) {
            textures.putAll(parent.getTextureMap());
        }
        textures.putAll(this.textures());
        return textures;
    }

    private Map<LocationKey, NamedResourceList> getRlMapForSide(String side) throws IOException {
        return this.getRlMapForSide(side, Map.of());
    }

    private Map<LocationKey, NamedResourceList> getRlMapForSide(String side, Map<String, String> oldTexMap) throws IOException {
        HashMap<LocationKey, NamedResourceList> map = new HashMap<LocationKey, NamedResourceList>();
        HashMap<String, String> texMap = new HashMap<String, String>(oldTexMap);
        texMap.putAll(this.getTextureMap());
        if (this.parent().isPresent()) {
            map.putAll(ParsedModel.getFromLocation(this.parent().get()).getRlMapForSide(side, texMap));
        }
        if (this.children().isEmpty() || this.children().get().isEmpty()) {
            for (ElementDefinition definition : this.elements()) {
                if (!definition.faces.containsKey(side)) continue;
                String texName = ParsedModel.resolveTextureSymbol(texMap, definition.faces.get(side).texture());
                LocationKey key2 = definition.getLocationKey();
                NamedResourceList rls2 = map.computeIfAbsent(key2, k -> new NamedResourceList(texName));
                rls2.name = texName;
                ResourceLocation location = ParsedModel.resolveTexture(texMap, "#" + texName);
                if (location == null) continue;
                rls2.resources.add(location);
            }
        } else {
            for (ParsedModel h : this.children().get().values()) {
                Map<LocationKey, NamedResourceList> m = h.getRlMapForSide(side, texMap);
                m.forEach((key, rls) -> map.merge((LocationKey)key, (NamedResourceList)rls, (l1, l2) -> {
                    NamedResourceList out = new NamedResourceList(l1.name);
                    out.resources.addAll(l1.resources);
                    out.resources.addAll(l2.resources);
                    return out;
                }));
            }
        }
        return map;
    }

    private Map<String, SideInformation> processIntoSides() throws IOException {
        HashMap<String, SideInformation> sides = new HashMap<String, SideInformation>();
        for (Face face : Face.values()) {
            Map<LocationKey, NamedResourceList> map = this.getRlMapForSide(face.faceName);
            for (NamedResourceList value : map.values()) {
                sides.computeIfAbsent((String)value.name, (Function<String, SideInformation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processIntoSides$6(dev.lukebemish.excavatedvariants.impl.client.ParsedModel$NamedResourceList java.lang.String ), (Ljava/lang/String;)Ldev/lukebemish/excavatedvariants/impl/client/ParsedModel$SideInformation;)((NamedResourceList)value)).faces.add(face);
            }
        }
        return sides;
    }

    public ModelData makeStoneModel() throws IOException {
        Map<String, SideInformation> sides = this.processIntoSides();
        return new StoneModelData(this, sides);
    }

    public TexFaceProvider makeTextureProvider() throws IOException {
        HashMap map = new HashMap();
        for (Face face2 : Face.values()) {
            Map<LocationKey, NamedResourceList> rlMap = this.getRlMapForSide(face2.faceName);
            map.put(face2, rlMap.values().stream().findFirst().map(it -> it.resources).orElse(List.of()));
        }
        return face -> (newStone, oldStone) -> {
            List oreTextures = (List)map.get((Object)face);
            int[] c = new int[]{0};
            HashMap<CallSite, AnimationSplittingSource.TimeAwareSource> sourceMap = new HashMap<CallSite, AnimationSplittingSource.TimeAwareSource>();
            ITexSource newStoneSource = (ITexSource)newStone.apply(source -> {
                String name = "stoneNew" + c[0];
                c[0] = c[0] + 1;
                sourceMap.put((CallSite)((Object)name), new AnimationSplittingSource.TimeAwareSource(source.cached(), 1));
                return new AnimationFrameCapture(name);
            });
            c[0] = 0;
            ITexSource oldStoneSource = (ITexSource)oldStone.apply(source -> {
                String name = "stoneOld" + c[0];
                c[0] = c[0] + 1;
                sourceMap.put((CallSite)((Object)name), new AnimationSplittingSource.TimeAwareSource(source.cached(), 1));
                return new AnimationFrameCapture(name);
            });
            c[0] = 0;
            ArrayList<AnimationFrameCapture> oreSources = new ArrayList<AnimationFrameCapture>();
            for (ResourceLocation location : (List)map.get((Object)face)) {
                String name = "ore" + c[0];
                c[0] = c[0] + 1;
                sourceMap.put((CallSite)((Object)name), new AnimationSplittingSource.TimeAwareSource(new TextureReader(location).cached(), 1));
                oreSources.add(new AnimationFrameCapture(name));
            }
            return new Pair((Object)new AnimationSplittingSource(sourceMap, (ITexSource)new ForegroundTransfer(oldStoneSource, (ITexSource)new Overlay(oreSources), newStoneSource, 6, true, true, true, 0.2)).cached(), (Object)oreTextures);
        };
    }

    private static /* synthetic */ SideInformation lambda$processIntoSides$6(NamedResourceList value, String k) {
        return new SideInformation(new HashSet<Face>(), new ArrayList<ResourceLocation>(value.resources));
    }

    public record ElementDefinition(Map<String, FaceDefinition> faces, List<Integer> from, List<Integer> to, RotationDefinition rotation) {
        public static final Codec<ElementDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING, FaceDefinition.CODEC).optionalFieldOf("faces", Map.of()).forGetter(ElementDefinition::faces), (App)Codec.INT.listOf().optionalFieldOf("from", List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0))).forGetter(ElementDefinition::from), (App)Codec.INT.listOf().optionalFieldOf("to", List.of(Integer.valueOf(16), Integer.valueOf(16), Integer.valueOf(16))).forGetter(ElementDefinition::to), (App)RotationDefinition.CODEC.optionalFieldOf("rotation", (Object)new RotationDefinition(List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)), "x", 0.0f)).forGetter(ElementDefinition::rotation)).apply((Applicative)i, ElementDefinition::new));

        public LocationKey getLocationKey() {
            List<Integer> from = Stream.of(0, 1, 2).map(i -> Math.min(this.from().get((int)i), this.to().get((int)i))).toList();
            List<Integer> to = Stream.of(0, 1, 2).map(i -> Math.max(this.from().get((int)i), this.to().get((int)i))).toList();
            return new LocationKey(this.rotation().origin(), this.rotation().axis(), this.rotation().angle(), from, to);
        }
    }

    public record FaceDefinition(String texture) {
        public static final Codec<FaceDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("texture").forGetter(FaceDefinition::texture)).apply((Applicative)i, FaceDefinition::new));
    }

    public record LocationKey(List<Integer> origin, String axis, float angle, List<Integer> of, List<Integer> to) {
    }

    public static class NamedResourceList {
        public String name;
        public final List<ResourceLocation> resources;

        public NamedResourceList(String name) {
            this.name = name;
            this.resources = new ArrayList<ResourceLocation>();
        }
    }

    public record SideInformation(Set<Face> faces, List<ResourceLocation> textureStack) {
    }

    public record RotationDefinition(List<Integer> origin, String axis, float angle) {
        public static final Codec<RotationDefinition> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.listOf().fieldOf("origin").forGetter(RotationDefinition::origin), (App)Codec.STRING.fieldOf("axis").forGetter(RotationDefinition::axis), (App)Codec.FLOAT.fieldOf("angle").forGetter(RotationDefinition::angle)).apply((Applicative)i, RotationDefinition::new));
    }
}

