/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.client;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.IInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.IPathAwareInputStreamSource;
import dev.lukebemish.dynamicassetgenerator.api.IResourceGenerator;
import dev.lukebemish.dynamicassetgenerator.api.ResourceGenerationContext;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.ITexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureGenerator;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.TextureMetaGenerator;
import dev.lukebemish.excavatedvariants.api.client.Face;
import dev.lukebemish.excavatedvariants.api.client.ModelData;
import dev.lukebemish.excavatedvariants.api.client.NamedTextureProvider;
import dev.lukebemish.excavatedvariants.api.client.TexFaceProvider;
import dev.lukebemish.excavatedvariants.api.client.TextureProducer;
import dev.lukebemish.excavatedvariants.impl.ExcavatedVariants;
import dev.lukebemish.excavatedvariants.impl.ModifiedOreBlock;
import dev.lukebemish.excavatedvariants.impl.client.BlockStateData;
import dev.lukebemish.excavatedvariants.impl.client.ResourceCollector;
import dev.lukebemish.excavatedvariants.impl.data.BaseOre;
import dev.lukebemish.excavatedvariants.impl.data.BaseStone;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceAssembler
implements IPathAwareInputStreamSource {
    private final Map<String, BaseStone> originalPairs = new HashMap<String, BaseStone>();
    private final List<Pair<BaseOre, BaseStone>> toMake;
    private final Map<String, ResourceLocation> oreBlocks = new HashMap<String, ResourceLocation>();
    private final Map<String, ResourceLocation> stoneBlocks = new HashMap<String, ResourceLocation>();
    private final Map<ResourceLocation, List<ModelData>> stoneModels;
    private final Map<ResourceLocation, List<TexFaceProvider>> oreModels;
    private final Map<ResourceLocation, IInputStreamSource> resources = new HashMap<ResourceLocation, IInputStreamSource>();

    public ResourceAssembler(Map<BaseOre, BaseStone> originalPairs, List<Pair<BaseOre, BaseStone>> toMake) {
        BaseStone stone;
        BaseOre ore;
        for (Map.Entry<BaseOre, BaseStone> entry : originalPairs.entrySet()) {
            this.originalPairs.put(entry.getKey().id, entry.getValue());
        }
        this.toMake = toMake;
        for (Map.Entry<BaseOre, BaseStone> entry : originalPairs.entrySet()) {
            ore = entry.getKey();
            stone = entry.getValue();
            this.oreBlocks.put(ore.id, ore.blockId.get(0));
            this.stoneBlocks.put(stone.id, stone.blockId);
        }
        for (Pair pair : toMake) {
            ore = (BaseOre)pair.getFirst();
            stone = (BaseStone)pair.getSecond();
            this.oreBlocks.put(ore.id, ore.blockId.get(0));
            this.stoneBlocks.put(stone.id, stone.blockId);
        }
        this.stoneModels = ResourceCollector.makeStoneTextures(List.copyOf(this.stoneBlocks.values()));
        this.oreModels = ResourceCollector.makeOreTextures(List.copyOf(this.oreBlocks.values()));
    }

    public void assemble() {
        for (Pair<BaseOre, BaseStone> pair : this.toMake) {
            BaseOre ore = (BaseOre)pair.getFirst();
            BaseStone newStone = (BaseStone)pair.getSecond();
            BaseStone oldStone = this.originalPairs.get(ore.id);
            if (oldStone == null) {
                ExcavatedVariants.LOGGER.warn("Ore " + ore.id + " has no existing stone variant to extract from!");
                continue;
            }
            this.processPair(ore, oldStone, newStone);
        }
    }

    private void processPair(BaseOre ore, BaseStone oldStone, BaseStone newStone) {
        List<ModelData> oldStoneModels = this.stoneModels.get(this.stoneBlocks.get(oldStone.id));
        List<ModelData> newStoneModels = this.stoneModels.get(this.stoneBlocks.get(newStone.id));
        List<TexFaceProvider> oreModels = this.oreModels.get(this.oreBlocks.get(ore.id));
        if (oldStoneModels == null) {
            ExcavatedVariants.LOGGER.warn("No existing stone models found for " + oldStone.id);
            return;
        }
        if (newStoneModels == null) {
            ExcavatedVariants.LOGGER.warn("No new stone models found for " + newStone.id);
            return;
        }
        if (oreModels == null || oreModels.isEmpty()) {
            ExcavatedVariants.LOGGER.warn("No ore models found for " + ore.id);
            return;
        }
        ModelData oldStoneModel = oldStoneModels.get(0);
        int counter = 0;
        ArrayList<ResourceLocation> models = new ArrayList<ResourceLocation>();
        for (ModelData newStoneModel : newStoneModels) {
            for (TexFaceProvider oreModel : oreModels) {
                ResourceLocation modelLocation = new ResourceLocation("excavated_variants", "block/" + newStone.id + "_" + ore.id + "_" + counter);
                this.assembleModel(modelLocation, oreModel, oldStoneModel, newStoneModel, oldStone);
                models.add(modelLocation);
                ++counter;
            }
        }
        String fullId = newStone.id + "_" + ore.id;
        ModifiedOreBlock block = ExcavatedVariants.getBlocks().get(fullId);
        BlockStateData assembled = BlockStateData.create(block, models);
        Optional encoded = BlockStateData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)assembled).result();
        if (encoded.isPresent()) {
            String json = ExcavatedVariants.GSON_CONDENSED.toJson((JsonElement)encoded.get());
            this.resources.put(new ResourceLocation("excavated_variants", "blockstates/" + fullId + ".json"), (resourceLocation, context) -> () -> new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));
        } else {
            ExcavatedVariants.LOGGER.warn("Failed to encode blockstate for " + fullId);
        }
    }

    private void assembleModel(ResourceLocation modelLocation, TexFaceProvider ore, ModelData oldStone, ModelData newStone, BaseStone oldStoneData) {
        HashMap stoneFaceLocationMap = new HashMap();
        HashMap modelTextureTranslations = new HashMap();
        NamedTextureProvider[] oldStoneTexSource = new NamedTextureProvider[1];
        oldStone.produceTextures((name, texture, faces) -> {
            oldStoneTexSource[0] = texture;
        });
        if (oldStoneTexSource[0] == null) {
            ExcavatedVariants.LOGGER.warn("No existing stone texture found for " + oldStoneData.id);
            return;
        }
        int[] counter = new int[]{0};
        newStone.produceTextures((name, texture, faces) -> {
            counter[0] = counter[0] + 1;
            ResourceLocation location = new ResourceLocation(modelLocation.m_135827_(), modelLocation.m_135815_() + "_" + counter[0]);
            modelTextureTranslations.put(name, location);
            if (faces.isEmpty()) {
                return;
            }
            stoneFaceLocationMap.put(name, new StoneTexFace(new HashSet<Face>(faces), location, texture));
        });
        JsonElement model = newStone.assembleModel(Collections.unmodifiableMap(modelTextureTranslations));
        ResourceLocation modelJsonLocation = new ResourceLocation(modelLocation.m_135827_(), "models/" + modelLocation.m_135815_() + ".json");
        this.resources.put(modelJsonLocation, (resourceLocation, context) -> () -> new ByteArrayInputStream(model.toString().getBytes(StandardCharsets.UTF_8)));
        for (Map.Entry entry : stoneFaceLocationMap.entrySet()) {
            StoneTexFace stoneTexFace = (StoneTexFace)entry.getValue();
            Set<Face> faces2 = stoneTexFace.faces();
            TextureProducer oreTexture = ore.get((Face)((Object)faces2.stream().findFirst().get()));
            this.assembleTextures(stoneTexFace.textureLocation(), oreTexture, oldStoneTexSource[0], stoneTexFace.texture());
        }
    }

    @NotNull
    public Set<ResourceLocation> getLocations() {
        return this.resources.keySet();
    }

    @Nullable
    public IoSupplier<InputStream> get(ResourceLocation outRl, ResourceGenerationContext context) {
        return this.resources.get(outRl).get(outRl, context);
    }

    private void assembleTextures(ResourceLocation output, TextureProducer oreTexture, NamedTextureProvider oldStoneTexture, NamedTextureProvider newStoneTexture) {
        ArrayList<ResourceLocation> usedLocations = new ArrayList<ResourceLocation>();
        Pair<ITexSource, List<ResourceLocation>> oreTextureResult = oreTexture.produce(newStoneTexture, oldStoneTexture);
        ITexSource outTexture = ((ITexSource)oreTextureResult.getFirst()).cached();
        usedLocations.addAll((Collection)oreTextureResult.getSecond());
        usedLocations.addAll(oldStoneTexture.getUsedTextures());
        usedLocations.addAll(newStoneTexture.getUsedTextures());
        this.processGenerator((IResourceGenerator)new TextureMetaGenerator(usedLocations, Optional.empty(), Optional.empty(), Optional.empty(), output));
        this.processGenerator((IResourceGenerator)new TextureGenerator(output, outTexture));
    }

    private void processGenerator(IResourceGenerator generator) {
        for (ResourceLocation location : generator.getLocations()) {
            this.resources.put(location, (IInputStreamSource)generator);
        }
    }

    private record StoneTexFace(Set<Face> faces, ResourceLocation textureLocation, NamedTextureProvider texture) {
    }
}

