/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.ITexSource;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.Overlay;
import dev.lukebemish.dynamicassetgenerator.api.client.generators.texsources.TextureReader;
import dev.lukebemish.excavatedvariants.api.client.ModelData;
import dev.lukebemish.excavatedvariants.api.client.NamedTextureProvider;
import dev.lukebemish.excavatedvariants.api.client.TextureProducer;
import dev.lukebemish.excavatedvariants.impl.client.ParsedModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

class StoneModelData
implements ModelData {
    private final ParsedModel parsedModel;
    private final Map<String, ParsedModel.SideInformation> sides;

    public StoneModelData(ParsedModel parsedModel, Map<String, ParsedModel.SideInformation> sides) {
        this.parsedModel = parsedModel;
        this.sides = sides;
    }

    @Override
    public JsonElement assembleModel(Map<String, ResourceLocation> textures) {
        HashMap<String, String> textureMap = new HashMap<String, String>(this.parsedModel.textures());
        for (Map.Entry<String, ResourceLocation> entry : textures.entrySet()) {
            textureMap.put(entry.getKey(), entry.getValue().toString());
        }
        ParsedModel newModel = new ParsedModel(this.parsedModel.parent(), textureMap, this.parsedModel.elements(), this.parsedModel.children());
        return (JsonElement)ParsedModel.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)newModel).result().orElse(new JsonObject());
    }

    @Override
    public void produceTextures(ModelData.TextureConsumer textureProducerConsumer) {
        for (Map.Entry<String, ParsedModel.SideInformation> entry : this.sides.entrySet()) {
            ParsedModel.SideInformation info;
            List<ResourceLocation> stack;
            String name = entry.getKey();
            if (!this.parsedModel.textures().containsKey(name) || (stack = (info = entry.getValue()).textureStack()).isEmpty()) continue;
            textureProducerConsumer.accept(name, new NamedTextureProvider(){

                @Override
                public ITexSource apply(TextureProducer.SourceWrapper sourceWrapper) {
                    return new Overlay(stack.stream().map(rl -> sourceWrapper.wrap((ITexSource)new TextureReader(rl))).toList());
                }

                @Override
                public List<ResourceLocation> getUsedTextures() {
                    return stack;
                }
            }, info.faces());
        }
    }
}

