/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class VariantAssembler {
    public static final Codec<VariantAssembler> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("model").forGetter(VariantAssembler::getModel), (App)Codec.INT.optionalFieldOf("x", (Object)0).forGetter(VariantAssembler::getX), (App)Codec.INT.optionalFieldOf("y", (Object)0).forGetter(VariantAssembler::getY)).apply((Applicative)instance, VariantAssembler::new));
    private final ResourceLocation model;
    private int x;
    private int y;

    public ResourceLocation getModel() {
        return this.model;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public VariantAssembler(ResourceLocation model) {
        this.model = model;
        this.x = 0;
        this.y = 0;
    }

    public VariantAssembler(ResourceLocation model, int x, int y) {
        this.model = model;
        this.x = x;
        this.y = y;
    }

    public static VariantAssembler fromFacing(ResourceLocation model, Direction dir) {
        VariantAssembler va = new VariantAssembler(model);
        switch (dir) {
            case UP: {
                va.x = 270;
                break;
            }
            case DOWN: {
                va.x = 90;
                break;
            }
            case EAST: {
                va.y = 90;
                break;
            }
            case NORTH: {
                break;
            }
            case WEST: {
                va.y = 270;
                break;
            }
            case SOUTH: {
                va.y = 180;
            }
        }
        return va;
    }

    public static VariantAssembler fromAxis(ResourceLocation model, Direction.Axis axis) {
        VariantAssembler va = new VariantAssembler(model);
        switch (axis) {
            case X: {
                va.x = 90;
                va.y = 90;
                break;
            }
            case Y: {
                break;
            }
            case Z: {
                va.x = 90;
            }
        }
        return va;
    }

    public static VariantAssembler fromModel(ResourceLocation model) {
        return new VariantAssembler(model);
    }
}

