/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.codecs;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lukebemish.excavatedvariants.impl.codecs.CommentingOps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CommentedCodec<A>
implements Codec<A> {
    private final Map<List<String>, String> comments;
    private final Codec<A> codec;

    public static <T> CommentedCodec<T> of(Codec<T> codec) {
        return new CommentedCodec<T>(codec);
    }

    protected CommentedCodec(Codec<A> wrapped) {
        this.codec = wrapped;
        this.comments = new HashMap<List<String>, String>();
    }

    public <T1> DataResult<Pair<A, T1>> decode(DynamicOps<T1> ops, T1 input) {
        return this.codec.decode(ops, input);
    }

    public <T1> DataResult<T1> encode(A input, DynamicOps<T1> ops, T1 prefix) {
        DataResult data = this.codec.encode(input, ops, prefix);
        if (ops instanceof CommentingOps) {
            CommentingOps commentingOps = (CommentingOps)ops;
            Optional result = data.result();
            if (result.isPresent()) {
                Object object = result.get();
                this.comments.forEach((key, value) -> commentingOps.setComment(object, (List<String>)key, (String)value));
                return DataResult.success(object);
            }
        }
        return data;
    }

    public CommentedCodec<A> comment(String comment, String ... path) {
        this.comments.put(Arrays.stream(path).toList(), comment);
        return this;
    }

    public CommentedCodec<A> comment(String comment, List<String> path) {
        this.comments.put(path, comment);
        return this;
    }

    public CommentedCodec<A> comment(Map<List<String>, String> comments) {
        this.comments.putAll(comments);
        return this;
    }
}

