/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.codecs;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import dev.lukebemish.excavatedvariants.impl.codecs.CommentingOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class JanksonOps
implements CommentingOps<JsonElement> {
    public static final JanksonOps INSTANCE = new JanksonOps();

    @Override
    public void setComment(JsonElement input, List<String> path, String comment) {
        try {
            if (input instanceof JsonObject) {
                ArrayList<String> remaining;
                String single;
                JsonElement child;
                JsonObject object = (JsonObject)input;
                if (path.size() == 1) {
                    object.setComment(path.get(0), comment);
                }
                if ((child = object.get((Object)(single = (String)(remaining = new ArrayList<String>(path)).remove(0)))) == null) {
                    throw new UnsupportedOperationException("Cannot set comment on nonexistent object: " + single);
                }
                this.setComment(child, (List<String>)remaining, comment);
                return;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        throw new UnsupportedOperationException(String.format("Cannot set comments on children with path %s of object %s", path, input));
    }

    public JsonElement empty() {
        return JsonNull.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
        if (input instanceof JsonObject) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof JsonArray) {
            return (U)this.convertList(outOps, input);
        }
        if (input instanceof JsonNull) {
            return (U)outOps.empty();
        }
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            Object value = primitive.getValue();
            if (value instanceof String) {
                String string = (String)value;
                return (U)outOps.createString(string);
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                return (U)outOps.createNumeric(number);
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return (U)outOps.createBoolean(bool.booleanValue());
            }
        }
        throw new UnsupportedOperationException("JanksonOps was unable to convert a value: " + input);
    }

    public DataResult<Number> getNumberValue(JsonElement input) {
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            Object value = primitive.getValue();
            if (value instanceof Number) {
                Number number = (Number)value;
                return DataResult.success((Object)number);
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                return DataResult.success((Object)(Boolean.TRUE.equals(bool) ? 1 : 0));
            }
        }
        return DataResult.error(() -> "Not a number: " + input);
    }

    public JsonElement createNumeric(Number i) {
        return new JsonPrimitive((Object)i);
    }

    public DataResult<String> getStringValue(JsonElement input) {
        JsonPrimitive primitive;
        Object value;
        if (input instanceof JsonPrimitive && (value = (primitive = (JsonPrimitive)input).getValue()) instanceof String) {
            String string = (String)value;
            return DataResult.success((Object)string);
        }
        return DataResult.error(() -> "Not a string: " + input);
    }

    public JsonElement createString(String value) {
        return new JsonPrimitive((Object)value);
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, JsonElement value) {
        if (list instanceof JsonArray || list == this.empty()) {
            JsonArray result = new JsonArray();
            if (list != this.empty()) {
                JsonArray array = (JsonArray)list;
                result.addAll((Collection)array);
            }
            result.add(value);
            return DataResult.success((Object)result);
        }
        return DataResult.error(() -> "mergeToList called with not a list: " + list, (Object)list);
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, List<JsonElement> values) {
        if (list instanceof JsonArray || list == this.empty()) {
            JsonArray result = new JsonArray();
            if (list != this.empty()) {
                JsonArray array = (JsonArray)list;
                result.addAll((Collection)array);
            }
            result.addAll(values);
            return DataResult.success((Object)result);
        }
        return DataResult.error(() -> "mergeToList called with not a list: " + list, (Object)list);
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, JsonElement key, JsonElement value) {
        JsonPrimitive primitive;
        Object object;
        if (!(map instanceof JsonObject) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + map, (Object)map);
        }
        if (!(key instanceof JsonPrimitive) || !((object = (primitive = (JsonPrimitive)key).getValue()) instanceof String)) {
            return DataResult.error(() -> "key is not a string: " + key, (Object)map);
        }
        String string = (String)object;
        JsonObject output = new JsonObject();
        if (map != this.empty()) {
            JsonObject jsonObject = (JsonObject)map;
            output.putAll((Map)jsonObject);
        }
        output.put(string, value);
        return DataResult.success((Object)output);
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, MapLike<JsonElement> values) {
        if (!(map instanceof JsonObject) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + map, (Object)map);
        }
        JsonObject output = new JsonObject();
        if (map != this.empty()) {
            JsonObject jsonObject = (JsonObject)map;
            output.putAll((Map)jsonObject);
        }
        ArrayList missed = new ArrayList();
        values.entries().forEach(entry -> {
            JsonPrimitive primitive;
            Object patt6108$temp;
            Object patt6049$temp = entry.getFirst();
            if (patt6049$temp instanceof JsonPrimitive && (patt6108$temp = (primitive = (JsonPrimitive)patt6049$temp).getValue()) instanceof String) {
                String string = (String)patt6108$temp;
                output.put(string, (JsonElement)entry.getSecond());
            } else {
                missed.add((JsonElement)entry.getFirst());
            }
        });
        if (!missed.isEmpty()) {
            return DataResult.error(() -> "some keys are not strings: " + missed, (Object)output);
        }
        return DataResult.success((Object)output);
    }

    public DataResult<MapLike<JsonElement>> getMap(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error(() -> "Not a JSON object: " + input);
        }
        final JsonObject object = (JsonObject)input;
        return DataResult.success((Object)new MapLike<JsonElement>(){

            @Nullable
            public JsonElement get(JsonElement key) {
                JsonPrimitive primitive;
                Object object2;
                if (key instanceof JsonPrimitive && (object2 = (primitive = (JsonPrimitive)key).getValue()) instanceof String) {
                    String string = (String)object2;
                    return this.get(string);
                }
                return null;
            }

            @Nullable
            public JsonElement get(String key) {
                JsonElement element = object.get((Object)key);
                if (element instanceof JsonNull) {
                    return null;
                }
                return element;
            }

            public Stream<Pair<JsonElement, JsonElement>> entries() {
                return object.entrySet().stream().map(e -> Pair.of((Object)new JsonPrimitive(e.getKey()), (Object)((JsonElement)e.getValue())));
            }

            public String toString() {
                return "MapLike[" + object + "]";
            }
        });
    }

    public DataResult<Stream<Pair<JsonElement, JsonElement>>> getMapValues(JsonElement input) {
        if (input instanceof JsonObject) {
            JsonObject object = (JsonObject)input;
            return DataResult.success(object.entrySet().stream().map(entry -> Pair.of((Object)new JsonPrimitive(entry.getKey()), entry.getValue() instanceof JsonNull ? null : (JsonElement)entry.getValue())));
        }
        return DataResult.error(() -> "Not a JSON object: " + input);
    }

    public JsonElement createMap(Stream<Pair<JsonElement, JsonElement>> map) {
        JsonObject result = new JsonObject();
        map.forEach(p -> {
            JsonPrimitive primitive;
            Object patt8339$temp;
            Object patt8280$temp = p.getFirst();
            if (!(patt8280$temp instanceof JsonPrimitive) || !((patt8339$temp = (primitive = (JsonPrimitive)patt8280$temp).getValue()) instanceof String)) {
                throw new UnsupportedOperationException(((JsonElement)p.getFirst()).getClass().getSimpleName());
            }
            String string = (String)patt8339$temp;
            result.put(string, (JsonElement)p.getSecond());
        });
        return result;
    }

    public DataResult<Stream<JsonElement>> getStream(JsonElement input) {
        if (input instanceof JsonArray) {
            JsonArray array = (JsonArray)input;
            return DataResult.success(array.stream().map(e -> e instanceof JsonNull ? null : e));
        }
        return DataResult.error(() -> "Not a json array: " + input);
    }

    public JsonElement createList(Stream<JsonElement> input) {
        JsonArray result = new JsonArray();
        input.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return result;
    }

    public JsonElement remove(JsonElement input, String key) {
        if (input instanceof JsonObject) {
            JsonObject object = (JsonObject)input;
            JsonObject result = new JsonObject();
            result.putAll((Map)object);
            result.remove((Object)key);
            return result;
        }
        return input;
    }

    public String toString() {
        return "Jankson";
    }
}

