/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.codecs;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.lukebemish.excavatedvariants.impl.codecs.CommentingOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class TomlConfigOps
implements CommentingOps<Object> {
    public static final TomlConfigOps INSTANCE = new TomlConfigOps();

    protected Config newConfig() {
        return TomlFormat.newConfig();
    }

    public Object empty() {
        return NullObject.NULL_OBJECT;
    }

    public <U> U convertTo(DynamicOps<U> outOps, Object input) {
        if (input instanceof Config) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof Collection) {
            return (U)this.convertList(outOps, input);
        }
        if (input == null || input instanceof NullObject) {
            return (U)outOps.empty();
        }
        if (input instanceof Enum) {
            Enum enumValue = (Enum)input;
            return (U)outOps.createString(enumValue.name());
        }
        if (input instanceof Number) {
            Number number = (Number)input;
            return (U)outOps.createNumeric(number);
        }
        if (input instanceof String) {
            String string = (String)input;
            return (U)outOps.createString(string);
        }
        if (input instanceof Boolean) {
            Boolean bool = (Boolean)input;
            return (U)outOps.createBoolean(bool.booleanValue());
        }
        throw new UnsupportedOperationException("NightConfigOps was unable to convert a value: " + input);
    }

    public DataResult<Number> getNumberValue(Object i) {
        DataResult dataResult;
        if (i instanceof Number) {
            Number n = (Number)i;
            dataResult = DataResult.success((Object)n);
        } else {
            dataResult = DataResult.error(() -> "Not a number: " + i);
        }
        return dataResult;
    }

    public Object createNumeric(Number i) {
        return i;
    }

    public DataResult<String> getStringValue(Object input) {
        return input instanceof Config || input instanceof Collection ? DataResult.error(() -> "Not a string: " + input) : DataResult.success((Object)String.valueOf(input));
    }

    public Object createString(String value) {
        return value;
    }

    public DataResult<Object> mergeToList(Object list, Object value) {
        if (!(list instanceof Collection) && list != this.empty()) {
            return DataResult.error(() -> "mergeToList called with not a list: " + list, (Object)list);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        if (list != this.empty()) {
            Collection listAsCollection = (Collection)list;
            result.addAll(listAsCollection);
        }
        result.add(value);
        return DataResult.success(result);
    }

    public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
        if (!(map instanceof Config) && map != this.empty()) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + map, (Object)map);
        }
        DataResult<String> stringResult = this.getStringValue(key);
        Optional badResult = stringResult.error();
        if (badResult.isPresent()) {
            return DataResult.error(() -> "key is not a string: " + key, (Object)map);
        }
        return stringResult.flatMap(s -> {
            Config output = this.newConfig();
            if (map != this.empty()) {
                Config oldConfig = (Config)map;
                output.addAll((UnmodifiableConfig)oldConfig);
            }
            output.add(s, value);
            return DataResult.success((Object)output);
        });
    }

    public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
        if (!(input instanceof Config)) {
            return DataResult.error(() -> "Not a Config: " + input);
        }
        Config config = (Config)input;
        return DataResult.success(config.entrySet().stream().map(entry -> Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
    }

    public Object createMap(Stream<Pair<Object, Object>> map) {
        Config result = this.newConfig();
        map.forEach(p -> result.add((String)this.getStringValue(p.getFirst()).getOrThrow(false, s -> {}), p.getSecond()));
        return result;
    }

    public DataResult<Stream<Object>> getStream(Object input) {
        if (input instanceof Collection) {
            Collection collection = (Collection)input;
            return DataResult.success(collection.stream());
        }
        return DataResult.error(() -> "Not a collection: " + input);
    }

    public Object createList(Stream<Object> input) {
        return input.toList();
    }

    public Object remove(Object input, String key) {
        if (input instanceof Config) {
            Config oldConfig = (Config)input;
            Config result = this.newConfig();
            oldConfig.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(entry -> result.add(entry.getKey(), entry.getValue()));
            return result;
        }
        return input;
    }

    @Override
    public void setComment(Object input, List<String> path, String comment) {
        if (input instanceof CommentedConfig) {
            CommentedConfig config = (CommentedConfig)input;
            config.setComment(path, comment);
        }
    }
}

