/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class BaseOre
implements Cloneable {
    public static final Codec<BaseOre> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(bs -> bs.id), (App)Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).optionalFieldOf("orename").forGetter(bs -> {
        if (bs.oreName.size() == 1 && bs.oreName.get(0).equals(bs.id)) {
            return Optional.empty();
        }
        return Optional.of(Either.right(bs.oreName));
    }), (App)Codec.STRING.listOf().fieldOf("stone").forGetter(bs -> bs.stone), (App)ResourceLocation.f_135803_.listOf().fieldOf("block_id").forGetter(bs -> bs.blockId), (App)Codec.STRING.optionalFieldOf("en_name").forGetter(bs -> Optional.empty()), (App)Codec.STRING.listOf().fieldOf("types").forGetter(bs -> bs.types), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("lang", Map.of()).forGetter(bs -> bs.lang)).apply((Applicative)instance, BaseOre::new));
    public String id;
    public List<String> oreName;
    public List<String> stone;
    public List<ResourceLocation> blockId;
    public Map<String, String> lang;
    public List<String> types;

    public BaseOre(String id, Optional<Either<String, List<String>>> oreName, List<String> stone, List<ResourceLocation> blockId, Optional<String> enName, List<String> types, Map<String, String> lang) {
        this.id = id;
        this.oreName = new ArrayList<String>();
        if (oreName.isPresent()) {
            Either<String, List<String>> either = oreName.get();
            if (either.left().isPresent()) {
                this.oreName.add((String)either.left().get());
            } else if (either.right().isPresent()) {
                this.oreName.addAll((Collection)either.right().get());
            } else {
                this.oreName.add(id);
            }
        } else {
            this.oreName.add(id);
        }
        this.stone = stone;
        this.blockId = blockId;
        this.lang = new HashMap<String, String>(lang);
        if (enName.isPresent() && !this.lang.containsKey("en_us")) {
            this.lang.put("en_us", enName.get());
        }
        this.types = types;
    }

    public BaseOre clone() {
        try {
            return (BaseOre)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseOre baseStone = (BaseOre)o;
        return this.id.equals(baseStone.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

