/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.data.filter;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.lukebemish.excavatedvariants.impl.data.BaseOre;
import dev.lukebemish.excavatedvariants.impl.data.BaseStone;
import dev.lukebemish.excavatedvariants.impl.data.filter.ObjectFilter;
import dev.lukebemish.excavatedvariants.impl.data.filter.StringHeldFilter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Filter {
    public static final Codec<Filter> CODEC = ExtraCodecs.m_184415_(() -> Codec.either(StringHeldFilter.CODEC, ObjectFilter.CODEC).xmap(either -> {
        if (either.left().isPresent()) {
            return (Filter)either.left().get();
        }
        return (Filter)either.right().get();
    }, f -> {
        if (f instanceof StringHeldFilter) {
            StringHeldFilter single = (StringHeldFilter)f;
            return Either.left((Object)single);
        }
        return Either.right((Object)((ObjectFilter)f));
    }));

    public static Filter union(List<Filter> filters) {
        filters = filters.stream().flatMap(Filter::expandOr).toList();
        return new ObjectFilter.OrFilter(filters);
    }

    public static Filter union(Filter ... filters) {
        return Filter.union(Arrays.asList(filters));
    }

    public static Filter intersect(List<Filter> filters) {
        filters = filters.stream().flatMap(Filter::expandAnd).toList();
        return new ObjectFilter.AndFilter(filters);
    }

    public static Filter intersect(Filter ... filters) {
        return Filter.intersect(Arrays.asList(filters));
    }

    private static Stream<Filter> expandOr(Filter filter) {
        if (filter instanceof ObjectFilter.OrFilter) {
            ObjectFilter.OrFilter or = (ObjectFilter.OrFilter)filter;
            return or.filters().stream().flatMap(Filter::expandOr);
        }
        return Stream.of(filter);
    }

    private static Stream<Filter> expandAnd(Filter filter) {
        if (filter instanceof ObjectFilter.AndFilter) {
            ObjectFilter.AndFilter and = (ObjectFilter.AndFilter)filter;
            return and.filters().stream().flatMap(Filter::expandAnd);
        }
        return Stream.of(filter);
    }

    public boolean matches(BaseOre var1, BaseStone var2);

    public boolean matches(String var1, String var2);
}

