/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.forge;

import com.google.auto.service.AutoService;
import com.google.common.collect.BiMap;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.lukebemish.dynamicassetgenerator.api.ServerPrePackRepository;
import dev.lukebemish.excavatedvariants.impl.forge.mixin.ForgeTierSortingRegistryAccessor;
import dev.lukebemish.excavatedvariants.impl.platform.services.Platform;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.toposort.TopologicalSort;
import net.minecraftforge.forgespi.language.IModInfo;

@AutoService(value={Platform.class})
public class PlatformImpl
implements Platform {
    @Override
    public boolean isQuilt() {
        return false;
    }

    @Override
    public boolean isForge() {
        return true;
    }

    @Override
    public Collection<String> getModIds() {
        return ModList.get().getMods().stream().map(IModInfo::getModId).toList();
    }

    @Override
    public Path getConfigFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public Path getModDataFolder() {
        return FMLPaths.GAMEDIR.get().resolve("mod_data/excavated_variants");
    }

    @Override
    public boolean isClient() {
        return FMLLoader.getDist() == Dist.CLIENT;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<ResourceLocation> getMiningLevels() {
        ResourceLocation ORDERING = new ResourceLocation("forge", "item_tier_ordering.json");
        BiMap<ResourceLocation, Tier> tiers = ForgeTierSortingRegistryAccessor.getTiers();
        List<Tier> tierList = new ArrayList();
        try (InputStream stream2 = ServerPrePackRepository.getResource((ResourceLocation)ORDERING);
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream2, StandardCharsets.UTF_8));){
            ItemTierOrdering ordering = (ItemTierOrdering)ItemTierOrdering.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).getOrThrow(false, e -> {});
            boolean missingTiers = tiers.keySet().stream().anyMatch(tier -> !ordering.order.contains(tier));
            boolean extraTiers = ordering.order.stream().anyMatch(tier -> !tiers.containsKey(tier));
            if (!missingTiers && !extraTiers) {
                for (ResourceLocation rl : ordering.order) {
                    tierList.add((Tier)tiers.get((Object)rl));
                }
                List<ResourceLocation> list = tierList.stream().map(it -> {
                    ResourceLocation l = it.getTag().f_203868_();
                    return new ResourceLocation(l.m_135827_(), "blocks/" + l.m_135815_());
                }).toList();
                return list;
            }
        }
        catch (IOException | RuntimeException stream2) {
            // empty catch block
        }
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        Iterator iterator = tiers.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                ForgeTierSortingRegistryAccessor.getEdges().forEach((key, value) -> {
                    if (tiers.containsKey(key) && tiers.containsKey(value)) {
                        graph.putEdge((Object)((Tier)tiers.get(key)), (Object)((Tier)tiers.get(value)));
                    }
                });
                tierList = TopologicalSort.topologicalSort((Graph)graph, null);
                return tierList.stream().map(it -> {
                    ResourceLocation l = it.getTag().f_203868_();
                    return new ResourceLocation(l.m_135827_(), "blocks/" + l.m_135815_());
                }).toList();
            }
            Tier tier2 = (Tier)iterator.next();
            graph.addNode((Object)tier2);
        }
    }

    private record ItemTierOrdering(List<ResourceLocation> order) {
        static final Codec<ItemTierOrdering> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().optionalFieldOf("order", List.of()).forGetter(ItemTierOrdering::order)).apply((Applicative)instance, ItemTierOrdering::new));
    }
}

