/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.excavatedvariants.impl.worldgen;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class OreGenMapSavedData
extends SavedData {
    public static final String DATA_KEY = "excavated_variants:ore_replacement";
    public Map<Pair<Integer, Integer>, Integer> edgeCount = Collections.synchronizedMap(new HashMap());
    public Map<Pair<Integer, Integer>, Boolean> ranMap = Collections.synchronizedMap(new HashMap());

    public static OreGenMapSavedData load(CompoundTag tag) {
        OreGenMapSavedData data = new OreGenMapSavedData();
        int[] edge1 = tag.m_128465_("edge_1");
        int[] edge2 = tag.m_128465_("edge_2");
        int[] edge3 = tag.m_128465_("edge_3");
        int[] ran1 = tag.m_128465_("ran_1");
        int[] ran2 = tag.m_128465_("ran_2");
        int[] ran3 = tag.m_128465_("ran_3");
        if (edge1.length == edge2.length && edge1.length == edge3.length && ran1.length == ran2.length && ran1.length == ran3.length) {
            int i;
            for (i = 0; i < edge1.length; ++i) {
                data.edgeCount.put((Pair<Integer, Integer>)new Pair((Object)edge1[i], (Object)edge2[i]), edge3[i]);
            }
            for (i = 0; i < ran1.length; ++i) {
                data.ranMap.put((Pair<Integer, Integer>)new Pair((Object)ran1[i], (Object)ran2[i]), ran3[i] != 0);
            }
        }
        return data;
    }

    public static OreGenMapSavedData create() {
        return new OreGenMapSavedData();
    }

    public static OreGenMapSavedData getOrCreate(ServerLevelAccessor world) {
        return (OreGenMapSavedData)world.m_6018_().m_8895_().m_164861_(OreGenMapSavedData::load, OreGenMapSavedData::create, DATA_KEY);
    }

    @NotNull
    public CompoundTag m_7176_(CompoundTag tag) {
        ArrayList<Integer> edge1 = new ArrayList<Integer>();
        ArrayList<Integer> edge2 = new ArrayList<Integer>();
        ArrayList<Integer> edge3 = new ArrayList<Integer>();
        ArrayList<Integer> ran1 = new ArrayList<Integer>();
        ArrayList<Integer> ran2 = new ArrayList<Integer>();
        ArrayList<Integer> ran3 = new ArrayList<Integer>();
        for (Pair<Integer, Integer> p : this.edgeCount.keySet()) {
            edge1.add((Integer)p.getFirst());
            edge2.add((Integer)p.getSecond());
            edge3.add(this.edgeCount.get(p));
        }
        for (Pair<Integer, Integer> p : this.ranMap.keySet()) {
            ran1.add((Integer)p.getFirst());
            ran2.add((Integer)p.getSecond());
            ran3.add(Boolean.TRUE.equals(this.ranMap.get(p)) ? 1 : 0);
        }
        tag.m_128385_("edge_1", edge1.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("edge_2", edge2.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("edge_3", edge3.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("ran_1", ran1.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("ran_2", ran2.stream().mapToInt(Integer::intValue).toArray());
        tag.m_128385_("ran_3", ran3.stream().mapToInt(Integer::intValue).toArray());
        return tag;
    }
}

