/*
 * Decompiled with CFR 0.152.
 */
package dev.lukebemish.defaultresources.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.lukebemish.defaultresources.api.ResourceProvider;
import dev.lukebemish.defaultresources.impl.AutoMetadataFilePackResources;
import dev.lukebemish.defaultresources.impl.AutoMetadataFolderPackResources;
import dev.lukebemish.defaultresources.impl.Config;
import dev.lukebemish.defaultresources.impl.GroupedResourceProvider;
import dev.lukebemish.defaultresources.impl.ModMetaFile;
import dev.lukebemish.defaultresources.impl.PathResourceProvider;
import dev.lukebemish.defaultresources.impl.Services;
import dev.lukebemish.defaultresources.impl.ZipResourceProvider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultResources {
    public static final String MOD_ID = "defaultresources";
    public static final Logger LOGGER = LogManager.getLogger((String)"defaultresources");
    public static final String META_FILE_PATH = "defaultresources.meta.json";
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    public static ResourceProvider RESOURCE_PROVIDER;
    private static final List<ResourceProvider> QUEUED_PROVIDERS;
    private static final Map<String, BiFunction<String, PackType, Supplier<PackResources>>> QUEUED_RESOURCES;

    public static ResourceProvider assembleResourceProvider() {
        ArrayList<ResourceProvider> providers = new ArrayList<ResourceProvider>(QUEUED_PROVIDERS);
        try (Stream<Path> paths = Files.list(Services.PLATFORM.getGlobalFolder());){
            paths.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    providers.add(new PathResourceProvider((Path)path));
                } else if (path.getFileName().toString().endsWith(".zip")) {
                    providers.add(new ZipResourceProvider((Path)path));
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        providers.addAll(Services.PLATFORM.getJarProviders());
        return new GroupedResourceProvider(providers);
    }

    public static void forMod(Path configDir, Function<String, Path> inJarPathGetter, String modId) {
        block22: {
            Path defaultResourcesMeta = inJarPathGetter.apply(META_FILE_PATH);
            if (Files.exists(defaultResourcesMeta, new LinkOption[0])) {
                try (InputStream is = Files.newInputStream(defaultResourcesMeta, new OpenOption[0]);){
                    JsonObject obj = (JsonObject)GSON.fromJson((Reader)new BufferedReader(new InputStreamReader(is)), JsonObject.class);
                    ModMetaFile meta = (ModMetaFile)ModMetaFile.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow(false, e -> {});
                    Path defaultResources = inJarPathGetter.apply(meta.resourcesPath());
                    if (!Files.exists(defaultResources, new LinkOption[0])) break block22;
                    Config.ExtractionState extractionState = Config.INSTANCE.get().extract().getOrDefault(modId, Config.ExtractionState.UNEXTRACTED);
                    if (extractionState == Config.ExtractionState.UNEXTRACTED) {
                        QUEUED_PROVIDERS.add(new PathResourceProvider(defaultResources));
                        QUEUED_RESOURCES.put("__extracted_" + modId, (s, type) -> {
                            if (!Files.exists(defaultResources.resolve(type.m_10305_()), new LinkOption[0])) {
                                return null;
                            }
                            return () -> new AutoMetadataFolderPackResources((String)s, (PackType)type, defaultResources);
                        });
                        break block22;
                    }
                    if ((!meta.markerPath().isPresent() || Files.exists(configDir.resolve(meta.markerPath().get()), new LinkOption[0]) || !extractionState.extractIfMissing) && !extractionState.extractRegardless) break block22;
                    Config.INSTANCE.get().extract().put(modId, Config.ExtractionState.EXTRACTED);
                    if (!meta.zip()) {
                        Path outPath = Services.PLATFORM.getGlobalFolder().resolve(modId);
                        if (!Files.exists(outPath, new LinkOption[0])) {
                            DefaultResources.copyResources(defaultResources, outPath);
                        }
                    } else {
                        try (FileSystem zipFs = FileSystems.newFileSystem(URI.create("jar:" + Services.PLATFORM.getGlobalFolder().resolve(modId + ".zip").toAbsolutePath().toUri()), Collections.singletonMap("create", "true"));){
                            Path outPath = zipFs.getPath("/", new String[0]);
                            DefaultResources.copyResources(defaultResources, outPath);
                        }
                    }
                    if (meta.createsMarker() && meta.markerPath().isPresent() && !Files.exists(configDir.resolve(meta.markerPath().get()), new LinkOption[0])) {
                        try {
                            Path markerPath = configDir.resolve(meta.markerPath().get());
                            String comment = meta.markerPath().get().endsWith(".json5") || meta.markerPath().get().endsWith(".json") ? "// " : (meta.markerPath().get().endsWith(".toml") ? "# " : "");
                            Files.writeString(markerPath, (CharSequence)(comment + "This is a marker file created by " + modId + ". If the mod is marked as already extracted, default resources will not be re-extracted while this file exists.\n"), new OpenOption[0]);
                        }
                        catch (IOException e2) {
                            LOGGER.error("Issues writing marker file at {} for mod {}: ", meta.markerPath(), (Object)modId, (Object)e2);
                        }
                    }
                }
                catch (IOException | RuntimeException e3) {
                    LOGGER.error("Could not read meta file for mod {}", (Object)modId, (Object)e3);
                }
            }
        }
    }

    private static void copyResources(Path defaultResources, Path outPath) {
        try (Stream<Path> walk = Files.walk(defaultResources, new FileVisitOption[0]);){
            walk.forEach(p -> {
                try {
                    if (!Files.isDirectory(p, new LinkOption[0])) {
                        String rel = defaultResources.relativize((Path)p).toString();
                        Path newPath = outPath.resolve(rel);
                        if (!Files.exists(newPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(p, newPath, new CopyOption[0]);
                    }
                }
                catch (IOException e) {
                    LOGGER.error((Object)e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
    }

    public static void cleanupExtraction() {
        Config.INSTANCE.get().save();
    }

    @NotNull
    public static List<Pair<String, Pack.ResourcesSupplier>> getPackResources(PackType type) {
        ArrayList<Pair<String, Pack.ResourcesSupplier>> packs = new ArrayList<Pair<String, Pack.ResourcesSupplier>>();
        try (Stream<Path> files = Files.list(Services.PLATFORM.getGlobalFolder());){
            for (Path file : files.toList()) {
                Pack.ResourcesSupplier packResources;
                if (Files.isDirectory(file, new LinkOption[0])) {
                    packResources = s -> new AutoMetadataFolderPackResources(s, type, file);
                    packs.add((Pair<String, Pack.ResourcesSupplier>)new Pair((Object)file.getFileName().toString(), (Object)packResources));
                    continue;
                }
                if (!file.getFileName().toString().endsWith(".zip")) continue;
                packResources = s -> new AutoMetadataFilePackResources(s, type, file.toFile());
                packs.add((Pair<String, Pack.ResourcesSupplier>)new Pair((Object)file.getFileName().toString(), (Object)packResources));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        QUEUED_RESOURCES.forEach((s, biFunction) -> {
            Supplier resources = (Supplier)biFunction.apply(s, type);
            if (resources == null) {
                return;
            }
            packs.add(new Pair(s, arg_0 -> DefaultResources.lambda$getPackResources$7((Supplier)resources, arg_0)));
        });
        return packs;
    }

    private static /* synthetic */ PackResources lambda$getPackResources$7(Supplier resources, String str) {
        return (PackResources)resources.get();
    }

    static {
        QUEUED_PROVIDERS = new ArrayList<ResourceProvider>();
        QUEUED_RESOURCES = new HashMap<String, BiFunction<String, PackType, Supplier<PackResources>>>();
    }
}

